/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.common.internal.editor.BehaviorSection;
import org.eclipse.hyades.test.common.internal.editor.action.AddLoop;
import org.eclipse.hyades.test.common.internal.editor.action.AddTestInvocation;
import org.eclipse.hyades.test.common.internal.editor.action.NewBehaviorActionGroup;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.util.ContextIds;
import org.eclipse.hyades.test.java.internal.util.TestJavaUtil;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class JUnitBehaviorSection 
extends BehaviorSection
{
	protected static final int HELP_SECTION_ADD_LOOP_ACTION = 4;
	protected static final int HELP_SECTION_ADD_INV_ACTION = 5;

	/**
	 * Constructor for JUnitBehaviorSection
	 * @param editorForm
	 * @param eStructuralFeature
	 * @param addAction
	 */
	public JUnitBehaviorSection(JUnitBehaviorForm behaviorForm)
	{
		super(behaviorForm);
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.BehaviorSection#createNewBehaviorActionGroup()
	 */
	protected NewBehaviorActionGroup createNewBehaviorActionGroup()
	{
		NewBehaviorActionGroup group = new NewBehaviorActionGroup(this);

		AddLoop addLoop = new AddLoop(this, TestJavaPlugin.getString("LBL_LOOP"), TestJavaPlugin.getString("W_LOOP"));
		registerHelp(HELP_SECTION_ADD_LOOP_ACTION, addLoop);
		group.addAction(addLoop);

		AddTestInvocation addTestInvocation = new AddTestInvocation(this, TestJavaPlugin.getString("W_LWR_INV"))
		{
			protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite)
			{
				return TestJavaUtil.createInvokedTestSelectionDialog(testSuite, false);
			}				
		};
		registerHelp(HELP_SECTION_ADD_INV_ACTION, addTestInvocation);
		group.addAction(addTestInvocation);
		
		return group;
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_SECTION_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.BEHAVIOR_SECTION);				
				break;
				
			case HELP_SECTION_DOWN_ACTION:
				WorkbenchHelp.setHelp((Action)object, TestJavaPlugin.getID() + ContextIds.BEHAVIOR_SECTION_DOWN);
				break;
				
			case HELP_SECTION_UP_ACTION:
				WorkbenchHelp.setHelp((Action)object, TestJavaPlugin.getID() + ContextIds.BEHAVIOR_SECTION_UP);				
				break;

			case HELP_SECTION_ADD_LOOP_ACTION:
				WorkbenchHelp.setHelp((Action)object, TestJavaPlugin.getID() + ContextIds.ACT_ADD_LOOP);
				break;
				
			case HELP_SECTION_ADD_INV_ACTION:
				WorkbenchHelp.setHelp((Action)object, TestJavaPlugin.getID() + ContextIds.ACT_ADD_TEST_INV);				
				break;
		}
	}
}
