/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.cbe.*;

import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.cbe.CBEPackage
 * @generated
 */
public class CBESwitch {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static CBEPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBESwitch()
	{
		if (modelPackage == null) {
			modelPackage = CBEPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject)
	{
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case CBEPackage.CBE_COMMON_BASE_EVENT: {
					CBECommonBaseEvent cbeCommonBaseEvent = (CBECommonBaseEvent)theEObject;
					Object result = caseCBECommonBaseEvent(cbeCommonBaseEvent);
					if (result == null) result = caseCBEDefaultEvent(cbeCommonBaseEvent);
					if (result == null) result = caseAbstractDefaultEvent(cbeCommonBaseEvent);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_EXTENDED_DATA_ELEMENT: {
					CBEExtendedDataElement cbeExtendedDataElement = (CBEExtendedDataElement)theEObject;
					Object result = caseCBEExtendedDataElement(cbeExtendedDataElement);
					if (result == null) result = caseCBEDefaultElement(cbeExtendedDataElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_CONTEXT_DATA_ELEMENT: {
					CBEContextDataElement cbeContextDataElement = (CBEContextDataElement)theEObject;
					Object result = caseCBEContextDataElement(cbeContextDataElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_COMPONENT_IDENTIFICATION: {
					CBEComponentIdentification cbeComponentIdentification = (CBEComponentIdentification)theEObject;
					Object result = caseCBEComponentIdentification(cbeComponentIdentification);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_MSG_DATA_ELEMENT: {
					CBEMsgDataElement cbeMsgDataElement = (CBEMsgDataElement)theEObject;
					Object result = caseCBEMsgDataElement(cbeMsgDataElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_DEFAULT_EVENT: {
					CBEDefaultEvent cbeDefaultEvent = (CBEDefaultEvent)theEObject;
					Object result = caseCBEDefaultEvent(cbeDefaultEvent);
					if (result == null) result = caseAbstractDefaultEvent(cbeDefaultEvent);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_DEFAULT_ELEMENT: {
					CBEDefaultElement cbeDefaultElement = (CBEDefaultElement)theEObject;
					Object result = caseCBEDefaultElement(cbeDefaultElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_SITUATION: {
					CBESituation cbeSituation = (CBESituation)theEObject;
					Object result = caseCBESituation(cbeSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_START_SITUATION: {
					CBEStartSituation cbeStartSituation = (CBEStartSituation)theEObject;
					Object result = caseCBEStartSituation(cbeStartSituation);
					if (result == null) result = caseCBESituation(cbeStartSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_CONNECT_SITUATION: {
					CBEConnectSituation cbeConnectSituation = (CBEConnectSituation)theEObject;
					Object result = caseCBEConnectSituation(cbeConnectSituation);
					if (result == null) result = caseCBESituation(cbeConnectSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_STOP_SITUATION: {
					CBEStopSituation cbeStopSituation = (CBEStopSituation)theEObject;
					Object result = caseCBEStopSituation(cbeStopSituation);
					if (result == null) result = caseCBESituation(cbeStopSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_REPORT_SITUATION: {
					CBEReportSituation cbeReportSituation = (CBEReportSituation)theEObject;
					Object result = caseCBEReportSituation(cbeReportSituation);
					if (result == null) result = caseCBESituation(cbeReportSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_FEATURE_SITUATION: {
					CBEFeatureSituation cbeFeatureSituation = (CBEFeatureSituation)theEObject;
					Object result = caseCBEFeatureSituation(cbeFeatureSituation);
					if (result == null) result = caseCBESituation(cbeFeatureSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_CONFIGURE_SITUATION: {
					CBEConfigureSituation cbeConfigureSituation = (CBEConfigureSituation)theEObject;
					Object result = caseCBEConfigureSituation(cbeConfigureSituation);
					if (result == null) result = caseCBESituation(cbeConfigureSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_DEPENDENCY_SITUATION: {
					CBEDependencySituation cbeDependencySituation = (CBEDependencySituation)theEObject;
					Object result = caseCBEDependencySituation(cbeDependencySituation);
					if (result == null) result = caseCBESituation(cbeDependencySituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_CREATE_SITUATION: {
					CBECreateSituation cbeCreateSituation = (CBECreateSituation)theEObject;
					Object result = caseCBECreateSituation(cbeCreateSituation);
					if (result == null) result = caseCBESituation(cbeCreateSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_DESTROY_SITUATION: {
					CBEDestroySituation cbeDestroySituation = (CBEDestroySituation)theEObject;
					Object result = caseCBEDestroySituation(cbeDestroySituation);
					if (result == null) result = caseCBESituation(cbeDestroySituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_AVAILABLE_SITUATION: {
					CBEAvailableSituation cbeAvailableSituation = (CBEAvailableSituation)theEObject;
					Object result = caseCBEAvailableSituation(cbeAvailableSituation);
					if (result == null) result = caseCBESituation(cbeAvailableSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_REQUEST_SITUATION: {
					CBERequestSituation cbeRequestSituation = (CBERequestSituation)theEObject;
					Object result = caseCBERequestSituation(cbeRequestSituation);
					if (result == null) result = caseCBESituation(cbeRequestSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_OTHER_SITUATION: {
					CBEOtherSituation cbeOtherSituation = (CBEOtherSituation)theEObject;
					Object result = caseCBEOtherSituation(cbeOtherSituation);
					if (result == null) result = caseCBESituation(cbeOtherSituation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Common Base Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Common Base Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBECommonBaseEvent(CBECommonBaseEvent object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Extended Data Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Extended Data Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEExtendedDataElement(CBEExtendedDataElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Context Data Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Context Data Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEContextDataElement(CBEContextDataElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Component Identification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Component Identification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEComponentIdentification(CBEComponentIdentification object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Msg Data Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Msg Data Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEMsgDataElement(CBEMsgDataElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Default Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Default Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEDefaultEvent(CBEDefaultEvent object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Default Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Default Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEDefaultElement(CBEDefaultElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBESituation(CBESituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Start Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Start Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEStartSituation(CBEStartSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Connect Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Connect Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEConnectSituation(CBEConnectSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Stop Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Stop Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEStopSituation(CBEStopSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Report Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Report Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEReportSituation(CBEReportSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Feature Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Feature Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEFeatureSituation(CBEFeatureSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Configure Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Configure Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEConfigureSituation(CBEConfigureSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Dependency Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Dependency Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEDependencySituation(CBEDependencySituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Create Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Create Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBECreateSituation(CBECreateSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Destroy Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Destroy Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEDestroySituation(CBEDestroySituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Available Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Available Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEAvailableSituation(CBEAvailableSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Request Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Request Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBERequestSituation(CBERequestSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Other Situation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Other Situation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEOtherSituation(CBEOtherSituation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract Default Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract Default Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractDefaultEvent(AbstractDefaultEvent object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object)
	{
		return null;
	}

} //CBESwitch
