/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import java.io.FileInputStream;
import java.io.IOException;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

/**
 * Action for Stop recording button on Recorder Control View
 * @author Ernest Jessee
 */
public class StopRecordingAction extends Action implements IAction
{
	
	/**
	 * run method
	 */
	public void run()
	{
		
		Recorder recorder = RecorderFactory.getInstance().getActiveRecorder();
		if(recorder!=null)	
			recorder.stopRecorder();
	}
	

	/**
	 * @see org.eclipse.jface.action.IAction#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor()
	{
		return new ImageDescriptor()
		{	
			public ImageData getImageData()
			{
				try
				{
					String path = Platform.resolve(RecorderPlugin.getDefault().getDescriptor().getInstallURL()).toString()+"icons/stoprecording.gif"; //$NON-NLS-1$
					path = path.substring(5,path.length());
					return new ImageData(new FileInputStream(path));
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
				return null;
			}
	
		};
	}

	/**
	 * @see org.eclipse.jface.action.IAction#getToolTipText()
	 */
	public String getToolTipText()
	{
		return RecorderPlugin.getResourceString("StopRecordingAction.STOP_RECORDING_BUTTON_TOOLTIP"); //$NON-NLS-1$
	}

}
