package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * This is the interface that embodies the Association Engine as described in 
 * "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0
 */
public interface IAssociationEngine {
	
	/**
	 * Value for the <em><b>Type</b></em> attribute.
	 * <P>
	 * The association represents containment of other events within a 
	 * root event.
	 * 
	 * @see #getType()
	 */
	static String TYPE_CONTAIN = "Contain";

	/**
	 * Value for the <em><b>Type</b></em> attribute.
	 * <P>
	 * The association represents a causality allowing the associated event to 
	 * point to the cause of the situation.
	 * 
	 * @see #getType()
	 */
	static String TYPE_CAUSED_BY = "CausedBy";

	/**
	 * Value for the <em><b>Type</b></em> attribute.
	 * <P>
	 * The association represents a relationship where an event points to an 
	 * event which fixes, or results in the situation to becoming irrelevant.
	 * 
	 * @see #getType()
	 */
	static String TYPE_CLEARED = "Cleared";

	/**
	 * Value for the <em><b>Type</b></em> attribute.
	 * <P>
	 * The association represents a collection of events together comprise a 
	 * single event.
	 * 
	 * @see #getType()
	 */
	static String TYPE_MULTI_PART = "MultiPart";

	/**
	 * Value for the <em><b>Type</b></em> attribute.
	 * <P>
	 * The association represents a relationship between a child and parent 
	 * event based on a correlation algorithm specified in the name of the 
	 * association.
	 * 
	 * @see #getType()
	 */
	static String TYPE_CORRELATED = "Correlated";

    /**
     * Returns the id.
     * 
     * Id of the application that created the association. This is a REQUIRED property.
     * 
     * @return String
     */
    public String getId();

    /**
     * Sets the id.
     * 
     * Id of the application that created the association . This is a REQUIRED property.
     * 
     * @param id The id to set
     */
    public void setId(String id);

    /**
     * Returns the name.
     * 
     * Name of the application that created the association (e.g,. my correlation 
     * engine name). This is a REQUIRED property.
     * 
     * @return String
     */
    public String getName();

    /**
     * Returns the type.
     * 
     * This property should contain the type of association represented by this element.
     * Some well defined associations are:
     * 1. Contains
     * 2. Cleared
     * 3. CausedBy
     * 4. MultiPart
     * 5. Correlated
     * This is a REQUIRED property.
     * 
     * @return String
     */
    public String getType();

    /**
     * Sets the name.
     * 
     * Name of the application that created the association (e.g,. my correlation 
     * engine name). This is a REQUIRED property.
     * 
     * @param name The name to set
     */
    public void setName(String name);

    /**
     * Sets the type.
     * 
     * This property should contain the type of association represented by this element.
     * Some well defined associations are:
     * 1. Contains
     * 2. Cleared
     * 3. CausedBy
     * 4. MultiPart
     * 5. Correlated
     * This is a REQUIRED property.
     * 
     * @param type The type to set
     */
    public void setType(String type);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * Initialize a AssociationEngine so that it has a new guidand all components 
	 * are initialized to either zero or null
	 * 
	 * @since 1.0.1
	 */
	public void init();
}
