/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.events.exceptions;

/**
 * Exception to indicate that a value was not supplied for a
 * required attribute, when calling a method or creating an object.
 */
public class MissingValueException extends Exception
{

    private String attribName;

    /** Create a new MissingValueException.
     * 
     * @param attrName		The name of the attribute with the missing value.
     */

    public MissingValueException(String attrName)
    {
        this.attribName = attrName;
    }

    /** Get the name of the attribute with the missing value.
     * 
     * @return		The name of the attribute with the missing value.
     */
    public String getAttributeName()
    {
        return this.attribName;
    }

} /* end class MissingValueException */
