/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/**
 * This class extends the {@link junit.framework.TestCase} class adding the 
 * expected behavior defined in the 
 * {@link org.eclipse.hyades.test.java.junit.IHyadesTest} interface.
 * 
 * @author marcelop
 * @since 1.0.1
 */
public class HyadesTestCase 
extends TestCase implements IHyadesTest
{
	private String id;
	private String testInvocationId;
	private Test parent;
	
	private int iteration = 0;
	private int previousParentIteration = 0;
	private boolean synchronous = true;
	private boolean loop = false;

	/**
	 * Constructor for HyadesTestCase.
	 * @param name
	 */
	public HyadesTestCase(String name)
	{
		super(name);
	}

	/**
	 * @see IHyadesTest#getId()
	 */
	public String getId()
	{
		return id;
	}

	/**
	 * @see IHyadesTest#setId(String)
	 */
	public IHyadesTest setId(String id)
	{
		this.id = id;
		return this;
	}

	/**
	 * @see IHyadesTest#getTestInvocationId()
	 */
	public String getTestInvocationId()
	{
		return testInvocationId;
	}

	/**
	 * @see IHyadesTest#setTestInvocationId(java.lang.String)
	 */
	public IHyadesTest setTestInvocationId(String testInvocationId)
	{
		this.testInvocationId = testInvocationId;
		return this;
	}

	/**
	 * @see IHyadesTest#setParent(TestSuite)
	 */
	public void setParent(Test parent)
	{
		this.parent = parent;
	}

	/**
	 * @see IHyadesTest#getParent()
	 */
	public Test getParent()
	{
		return parent;
	}

	/**
	 * @see IHyadesTest#getIteration()
	 */
	public int getIteration()
	{
		return iteration;
	}

	/**
	 * @see org.eclipse.hyades.test.common.junit.IHyadesTest#setSynchronous(boolean)
	 */
	public IHyadesTest setSynchronous(boolean synchronous)
	{
		this.synchronous = synchronous;
		return this;
	}

	/**
	 * @see org.eclipse.hyades.test.common.junit.IHyadesTest#isSynchronous()
	 */
	public boolean isSynchronous()
	{
		return synchronous;
	}

	/**
	 * Calculates the current iteration comparing the number of executions
	 * with the iteration of the parent (if it is an instanceof  IHyadesTest).
	 */
	protected void adjustIteration()
	{
		if(parent != null)
		{
			int parentIteration = previousParentIteration;
			if(parent instanceof IHyadesTest)
				parentIteration = getParentIteration((IHyadesTest)parent);

			if(parentIteration != previousParentIteration)
			{
				iteration = 0;
				previousParentIteration = parentIteration;
			}
		}		
		iteration++;
	}


	protected int getParentIteration(IHyadesTest parent)
	{
		int i = parent.getIteration();

		while ( parent != null && !parent.isLoop() )
		{
			Test p = parent.getParent();
			if ( p != null && p instanceof IHyadesTest )
			{
				parent = (IHyadesTest) p;
				i = parent.getIteration();
			}
			else
				break;
		}
		return i;
	}


	/**
	 * @see junit.framework.Test#run(junit.framework.TestResult)
	 */
	public void run(TestResult testResult)
	{
		synchronized(this)
		{
			adjustIteration();
		}
		super.run(testResult);
	}

	/**
	 * @see IHyadesTest#toJUnitString()
	 */
	public String toJUnitString()
	{
		return super.toString();
	}

	/**
	 * Returns this test's hierarchy.
	 * @see Object#toString()
	 */
	public String toString()
	{
		return HyadesTestUtil.getHierarchy(this, false);
	}

	/**
	 * Returns true if this is a loop
	 * @see org.eclipse.hyades.test.common.junit.IHyadesTest#isLoop()
	 */
	public boolean isLoop() {
		return loop;
	}

	/**
	 * Sets whether or not this is a loop
	 * @see org.eclipse.hyades.test.common.junit.IHyadesTest#setLoop(boolean)
	 */
	public IHyadesTest setLoop(boolean loop) {
		this.loop = loop;
		return this;
	}

}
