/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.junit.wizard;

import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.codegen.HttpGenerator;
import org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard;

public class HttpGenerateWizard 
extends GenerateWizard
{
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard#createGenerator()
	 */
	protected Generator createGenerator()
	{
		return new HttpGenerator();
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard#addRequiredLibraries(org.eclipse.hyades.test.common.internal.codegen.Generator)
	 */
	protected void addRequiredLibraries(Generator generator)
	{
		HttpGenerator httpGenerator = (HttpGenerator)generator;
		httpGenerator.addAllLibraries(PLUGIN_ID_JUNIT);
		httpGenerator.addAllLibraries(PLUGIN_ID_EXECUTION_CORE);
		httpGenerator.addAllLibraries(PLUGIN_ID_EXECUTION_REMOTE);
		httpGenerator.addRequiredLibrary(TestCommonPlugin.getID(), "common.runner.jar");
		httpGenerator.addRequiredLibrary(TestHttpPlugin.getID(), "http.runner.jar");
	}
}