/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports;

import java.util.List;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.jface.wizard.Wizard;

/**
 * @author ejessee
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ResultsSelectionWizard extends Wizard
{

	private List results = null;
	private ResultsSelectionWizardPage wizPage = null;
	
	public ResultsSelectionWizard(List results)
	{
		this.results = results;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		addPage(wizPage = new ResultsSelectionWizardPage(results));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#canFinish()
	 */
	public boolean canFinish()
	{
		return wizPage.getSelectedResult()!=null;
	}

	/**
	 * @return
	 */
	public TPFExecutionResult getSelectedResult()
	{
		return wizPage.getSelectedResult();
	}

}
