/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports.responsetime;

import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.http.internal.reports.HTTPReportGenerator;
import org.eclipse.hyades.test.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.jface.viewers.ISelection;

/**
 * TODO: Provide description for "ReportGenerator1".
 * @see IReportGenerator
 */
public class ResponseTimeReportGenerator extends HTTPReportGenerator
{
	
	/**
	 * TODO: Implement "generate".
	 * @see IReportGenerator#generate
	 */
	public InputStream generate(IFile outputFile, ISelection sel) throws Exception 
	{
	 	initResultSelection();
	 	if(result==null)
			throw new Exception("problem resolving selected results");
	 	 
	 	 ResponseTimeReport report = new ResponseTimeReport(result);
		 ResponseTimeData.resetCumulativeValues();
		 
		 report.generate();
		 		 
		 ReportGraphConfiguration graphConfig = setupConfiguration();
		 		 
		 ReportGraph graph = new ReportGraph(report.getList(),graphConfig);		 
		 IPath svgPath = outputFile.getFullPath(); 
		 svgPath.removeFileExtension().addFileExtension("svg"); 
		 return graph.generate(svgPath);	
	
	}

	private ReportGraphConfiguration setupConfiguration()
	{
		ReportGraphConfiguration graphConfig = new ReportGraphConfiguration();
		 graphConfig.setTitle("Page Response Time");
		 graphConfig.setXTitle("Page");
		 graphConfig.setYTitle("Time (sec)");
		 graphConfig.setLegendTitle("Legend");
		 graphConfig.setTimeStampPrefix("");
		 graphConfig.setMinWidth(800);
		 graphConfig.setHeight(500);
		return graphConfig;
	}
}
