/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.trace.internal.loader;

import java.util.*;

import org.eclipse.hyades.models.trace.*;
import org.eclipse.hyades.sd.ui.internal.loader.*;
import org.eclipse.hyades.sd.ui.internal.model.*;

public class TRCThreadLoader extends TRCModelLoaderUtility implements IModelLoader
{
  private TRCThread thread = null;

  public TRCThreadLoader()
  {
  }
  
  public TRCThreadLoader(TRCThread thread, Graph inputGraph)
  {
    TRCThreadLoader loader = new TRCThreadLoader();
    loader.setThread(thread);
    loader.setGraph(inputGraph);
    graph = inputGraph;
  }
  
  public void setObjectAndGraph(Object mObject, Graph gr){
	graph = gr;
  } 
  
  public void setThread(TRCThread trcThread)
  {
    thread = trcThread;
  }
  private TRCThread getThread()
  {
    return thread;
  }

  public void load()
  {
    if (thread != null)
    {
      for (Iterator invocations = thread.getInitialInvocations().iterator(); invocations.hasNext();)
      {
        TRCMethodInvocation invocation = (TRCMethodInvocation) invocations.next();
        if (invocation != null)
        {
          NodeContainer container = resolveContainer(invocation, graph.getType());
          resolveMethodNode(invocation, container);
        } // invocation null test
      } // end invocations for loop
      // now go through each node and add the outbound connections
      resolveConnections();
    }
    //    Increment[] increments = graph.getIncrementWeights();
    //    for (int i = 0; i < increments.length; i++)
    //      if (increments[i] != null)
    //        System.out.println(
    //          "Position :" + increments[i].getValue() + " Weight :" + increments[i].getWeight());
  }
}
