/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

public class MethodNode  implements GraphNode {

	/**
	 * Constructor for MethodNode.
	 */
	public MethodNode() {
		super();
	}
	
	//implement GraphNode -> begin
	
  public String name=null;

  /**
   * The node type is an enumerated vaule yet to be defined. It could be used to 
   * control how the object is rendered.
   */
  public int type = 0;
  public double startTime = 0;
  public double endTime = 0;
  public Increment startIncrement = null;
  public Increment endIncrement = null;
  public int nextNewSourceConnection = 0;
  public int nextNewTargetConnection = 0;
  public int indexInContainer = 0;
  public String shortName = null;
  public String secondaryName = null;
  public int indexInTable = -1;
  private int xOffset = 0;

  /**
   * @since November 23, 2001
   */
  public Object userArea = null;
  public NodeContainer container = null;
  public Graph graph = null;
  public NodeConnection lastReadTargetConnection = null;
  public NodeConnection targetConnections[] = new NodeConnection[3];
  public NodeConnection sourceConnections[] = new NodeConnection[3];
	
	/**
   * @return String
   * @since November 23, 2001
   * @roseuid 3BFEB7F40117
   */
  public String getName()
  {
    return name;
  }
  /**
   * @return String
   * @since December 17, 2001
   */
  public String getShortName()
  {
    return shortName;
  }
  public void setShortName(String name)
  {
    shortName = name;
  }
  /**
  * @return String
  * @since December 17, 2001
  */
  public String getSecondaryName()
  {
    return secondaryName;
  }
  public void setSecondaryName(String name)
  {
    secondaryName = name;
  }

  /**
   * @param inputName
   * @since November 23, 2001
   * @roseuid 3BFEBE7F0039
   */
  public void setName(String inputName)
  {
    name = inputName;
  }

  /**
   * @return int
   * @since November 23, 2001
   * @roseuid 3BFEB825021B
   */
  public int getType()
  {
    return type;
  }

  /**
   * @param inputType
   * @since November 23, 2001
   * @roseuid 3BFEBE9E017E
   */
  public void setType(int inputType)
  {
    type = inputType;
  }

  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEB839031F
   */
  public double getStartTime()
  {

    return startTime;

  }

  /**
   * @param tine
   * @param time
   * @since November 23, 2001
   * @roseuid 3BFEBEAA030C
   */
  public void setStartTime(double time)
  {
    startTime = time;
    startIncrement = getGraph().addIncrementAppendDup(time);

  }
  public void setStartIncrement(Increment increment)
  {
    startTime = increment.getTime();
    startIncrement = increment;
  }

  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEB85401D3
   */
  public double getEndTime()
  {

    return endTime;

  }
  /**
  * @param time
  * @since November 23, 2001
  * @roseuid 3BFEBEB20263
  */
  public void setEndTime(double time)
  {
    endTime = time;
    endIncrement = getGraph().addIncrementAppendDup(time);
    
  }
  public void setEndIncrement(Increment increment)
  {
    endTime = increment.getTime();
    endIncrement = increment;
  }

  /**
  * @return int
  * @since December 06, 2001
  * 
  */
  public Increment getStartIncrement()
  {

    return startIncrement;

  }

  public int getStartIncrementValue()
  {
    // return new Double(startTime / getGraph().getSmallestTimeIncrement()).intValue();

    if (startIncrement != null)
      return startIncrement.getValue();
    else
      return 0;

  }

  /**
   * @return int
   * @since December 13, 2001
   * 
   */
  public Increment getEndIncrement()
  {

    return endIncrement;
  }

  public int getEndIncrementValue()
  {
    // return new Double(endTime / getGraph().getSmallestTimeIncrement()).intValue();
    if (endIncrement != null)
      return endIncrement.getValue();
    else
      return 0;
  }

  /**
   * @return com.ibm.etools.pd.sd.model.Graph
   * @since November 23, 2001
   * @roseuid 3BFEB87F00C6
   */
  public Graph getGraph()
  {
    if (graph == null)
      graph = getContainer().getGraph();
    return graph;
  }

  /**
   * @param inputGraph
   * @since November 23, 2001
   * @roseuid 3BFEC2BB029A
   */
  public void setGraph(Graph inputGraph)
  {
    graph = inputGraph;
  }

  /**
   * @return com.ibm.etools.pd.sd.model.NodeConnection
   * @since November 23, 2001
   * @roseuid 3BFEB89C0227
   */
  public NodeConnection getLastReadTargetConnection()
  {
    return lastReadTargetConnection;
  }

  /**
   * @param connection
   * @since November 23, 2001
   * @roseuid 3BFEC2C60098
   */
  public void setLastReadTargetConnection(NodeConnection connection)
  {
    lastReadTargetConnection = connection;
  }

  /**
   * @return com.ibm.etools.pd.sd.model.NodeContainer
   * @since November 23, 2001
   * @roseuid 3BFEB8BD02B0
   */
  public NodeContainer getContainer()
  {
    return container;
  }

  /**
   * @param container
   * @param inputContainer
   * @since November 23, 2001
   * @roseuid 3BFEBEEC018A
   */
  public void setContainer(NodeContainer inputContainer)
  {
    container = inputContainer;
  }

  /**
   * @return com.ibm.etools.pd.sd.model.NodeConnection
   * @since November 23, 2001
   * @roseuid 3BFEB8DA0208
   */
  public NodeConnection[] getSourceConnections()
  {
    return sourceConnections;
  }

  /**
   * @param connections
   * @since November 23, 2001
   * @roseuid 3BFEBEFD00E4
   */
  public void setSourceConnections(NodeConnection[] connections)
  {
    sourceConnections = connections;
  }

  /**
   * @return com.ibm.etools.pd.sd.model.NodeConnection
   * @since November 23, 2001
   * @roseuid 3BFEB90801B4
   */
  public NodeConnection[] getTargetConnections()
  {
    return targetConnections;
  }

  /**
   * @param connections
   * @since November 23, 2001
   * @roseuid 3BFEBF0E01D9
   */
  public void setTargetConnections(NodeConnection[] connections)
  {
    targetConnections = connections;
  }

  /**
   * This is an inbound connection in a call graph
   * @param connection
   * @since November 23, 2001
   * @roseuid 3BFEBF2A0229
   */
  public void addSourceConnection(NodeConnection connection)
  {
    try
    {
      sourceConnections[nextNewSourceConnection] = connection;
    }
    catch (ArrayIndexOutOfBoundsException e)
    {
      NodeConnection[] tempArray = new NodeConnection[2 * sourceConnections.length];
      System.arraycopy(sourceConnections, 0, tempArray, 0, sourceConnections.length);
      sourceConnections = tempArray;
      sourceConnections[nextNewSourceConnection] = connection;
    }
    // if the new connection end increment is is not between the node start and end
    // fix it
    if (connection.getEndIncrement().getValue() < getStartIncrement().getValue())
      graph.moveIncrementAndAdjust(
        getStartIncrement(),
        connection.getStartIncrement().getValue());
    if (connection.getEndIncrement().getValue() > getEndIncrement().getValue())
      graph.moveIncrementAndAdjust(
        connection.getEndIncrement(),
        getEndIncrement().getValue());

    nextNewSourceConnection++;

  }

  /**
   * @return void
   * @since December 03, 2001
   * 
   */
  public int getSourceConnectionCount()
  {
    return nextNewSourceConnection;
  }

  /**
   * This is an outbound connection in a call graph
   * @param connection
   * @since November 23, 2001
   * @roseuid 3BFEBF46019D
   */
  public void addTargetConnection(NodeConnection connection)
  {
    try
    {
      targetConnections[nextNewTargetConnection] = connection;
    }
    catch (ArrayIndexOutOfBoundsException e)
    {
      NodeConnection[] tempArray = new NodeConnection[2 * targetConnections.length];
      System.arraycopy(targetConnections, 0, tempArray, 0, targetConnections.length);
      targetConnections = tempArray;
      targetConnections[nextNewTargetConnection] = connection;
    }
    // if the new connection start increment is is not between the node start and end
    // fix it
    if (connection.getStartIncrement().getValue() < getStartIncrement().getValue())
      graph.moveIncrementAndAdjust(
        getStartIncrement(),
        connection.getStartIncrement().getValue());
    if (connection.getStartIncrement().getValue() > getEndIncrement().getValue())
      graph.moveIncrementAndAdjust(
        connection.getEndIncrement(),
        getEndIncrement().getValue());

    nextNewTargetConnection++;
  }

  /**
   * @return void
   * @since December 03, 2001
   * 
   */
  public int getTargetConnectionCount()
  {
    return nextNewTargetConnection;
  }

  /**
   * @param Hashtable
   * @since November 23, 2001
   * @roseuid 3BFEDA1001D1
   */
  public void setUserArea(Object area)
  {
    userArea = area;
  }

  /**
   * @return Hashtable
   * @since November 23, 2001
   * @roseuid 3BFEDA1C0246
   */
  public Object getUserArea()
  {
    return userArea;
  }
  /**
  * @return int
  * @since November 26, 2001
  * 
  */
  public int getIndexInContainer()
  {
    return indexInContainer;
  }
  /**
  * @return void
  * @since November 26, 2001
  * 
  */
  public void setIndexInContainer(int index)
  {
    indexInContainer = index;
  }
  //implement GraphNode -> end
  
  public void setIndexInTable(int index){
  	
     indexInTable = index;	
  }
  
  public int getIndexInTable(){
  	
     return indexInTable;	
  }

	/**
	 * @see com.ibm.etools.pd.sd.model.GraphNode#getXOffset()
	 */
	public int getXOffset() {
		return xOffset;
	}

	/**
	 * @see com.ibm.etools.pd.sd.model.GraphNode#setXOffset(int)
	 */
	public void setXOffset(int xOffset) {
		this.xOffset = xOffset;
	}

}
