/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.preferences;

import org.eclipse.hyades.sd.ui.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

/**
 * CONTEXT_ID topp0000 for Filter Call Options preference page.
 */

public class FilterCallPreferencePage extends PreferencePage
										implements IWorkbenchPreferencePage
{
	private Button _filterCall;

	public FilterCallPreferencePage() {
		super();
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			SDPlugin.getPluginId() + ".topp0000");

		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		
		Label label = new Label(composite, SWT.NULL);
		label.setText(SDPlugin.getString("STR_FILTER_DESCR"));
		
        _filterCall = new Button(composite, SWT.CHECK);
        _filterCall.setText(SDPlugin.getString("STR_FILTER_TEXT"));

		_filterCall.setSelection(
			getPreferenceStore().getBoolean(SDConstants.FILTER_SELF_CALL));
			
		label = new Label(composite, SWT.NONE);
		
		label = new Label(composite, SWT.NONE);
		label.setText(SDPlugin.getString("STR_FILTER_NOTE"));
			    		
		return composite;
	}
	/**
	* Returns preference store that belongs to the our plugin.
	* This is important because we want to store
	* our preferences separately from the desktop.
	*
	* @return the preference store for this plugin
	*/
	public IPreferenceStore getPreferenceStore() {
		return SDPlugin.getDefault().getPreferenceStore(); 
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		_filterCall.setSelection(
			getPreferenceStore().getDefaultBoolean(SDConstants.FILTER_SELF_CALL));
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		SDPlugin.getDefault().savePluginPreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		getPreferenceStore().setValue(
			SDConstants.FILTER_SELF_CALL,
			_filterCall.getSelection());
	}
}
