/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.parser.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.util.Guid;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rule Attribute Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleAttributeTypeImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleAttributeTypeImpl#getIndex <em>Index</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleAttributeTypeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleAttributeTypeImpl#isUsePreviousMatchSubstitutionAsDefault <em>Use Previous Match Substitution As Default</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleAttributeTypeImpl#getSubstitutionRule <em>Substitution Rule</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RuleAttributeTypeImpl extends EObjectImpl implements RuleAttributeType {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getIndex() <em>Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndex()
	 * @generated
	 * @ordered
	 */
	protected static final String INDEX_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIndex() <em>Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndex()
	 * @generated
	 * @ordered
	 */
	protected String index = INDEX_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isUsePreviousMatchSubstitutionAsDefault() <em>Use Previous Match Substitution As Default</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUsePreviousMatchSubstitutionAsDefault()
	 * @generated
	 * @ordered
	 */
	protected static final boolean USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isUsePreviousMatchSubstitutionAsDefault() <em>Use Previous Match Substitution As Default</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUsePreviousMatchSubstitutionAsDefault()
	 * @generated
	 * @ordered
	 */
	protected boolean usePreviousMatchSubstitutionAsDefault = USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT_EDEFAULT;

	/**
	 * This is true if the Use Previous Match Substitution As Default attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean usePreviousMatchSubstitutionAsDefaultESet = false;

	/**
	 * The cached value of the '{@link #getSubstitutionRule() <em>Substitution Rule</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubstitutionRule()
	 * @generated
	 * @ordered
	 */
	protected EList substitutionRule = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RuleAttributeTypeImpl() {
		super();
		
		index = (new Guid()).toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ParserPackage.eINSTANCE.getRuleAttributeType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ATTRIBUTE_TYPE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIndex() {
		return index;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIndex(String newIndex) {
		
		String oldIndex = index;
		index = newIndex;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ATTRIBUTE_TYPE__INDEX, oldIndex, index));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ATTRIBUTE_TYPE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isUsePreviousMatchSubstitutionAsDefault() {
		return usePreviousMatchSubstitutionAsDefault;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUsePreviousMatchSubstitutionAsDefault(boolean newUsePreviousMatchSubstitutionAsDefault) {
		boolean oldUsePreviousMatchSubstitutionAsDefault = usePreviousMatchSubstitutionAsDefault;
		usePreviousMatchSubstitutionAsDefault = newUsePreviousMatchSubstitutionAsDefault;
		boolean oldUsePreviousMatchSubstitutionAsDefaultESet = usePreviousMatchSubstitutionAsDefaultESet;
		usePreviousMatchSubstitutionAsDefaultESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT, oldUsePreviousMatchSubstitutionAsDefault, usePreviousMatchSubstitutionAsDefault, !oldUsePreviousMatchSubstitutionAsDefaultESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetUsePreviousMatchSubstitutionAsDefault() {
		boolean oldUsePreviousMatchSubstitutionAsDefault = usePreviousMatchSubstitutionAsDefault;
		boolean oldUsePreviousMatchSubstitutionAsDefaultESet = usePreviousMatchSubstitutionAsDefaultESet;
		usePreviousMatchSubstitutionAsDefault = USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT_EDEFAULT;
		usePreviousMatchSubstitutionAsDefaultESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT, oldUsePreviousMatchSubstitutionAsDefault, USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT_EDEFAULT, oldUsePreviousMatchSubstitutionAsDefaultESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetUsePreviousMatchSubstitutionAsDefault() {
		return usePreviousMatchSubstitutionAsDefaultESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubstitutionRule() {
		if (substitutionRule == null) {
			substitutionRule = new EObjectContainmentEList(SubstitutionRuleType.class, this, ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE);
		}
		return substitutionRule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE:
					return ((InternalEList)getSubstitutionRule()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE_TYPE__ID:
				return getId();
			case ParserPackage.RULE_ATTRIBUTE_TYPE__INDEX:
				return getIndex();
			case ParserPackage.RULE_ATTRIBUTE_TYPE__NAME:
				return getName();
			case ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				return isUsePreviousMatchSubstitutionAsDefault() ? Boolean.TRUE : Boolean.FALSE;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE:
				return getSubstitutionRule();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE_TYPE__ID:
				setId((String)newValue);
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__INDEX:
				setIndex((String)newValue);
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__NAME:
				setName((String)newValue);
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				setUsePreviousMatchSubstitutionAsDefault(((Boolean)newValue).booleanValue());
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE:
				getSubstitutionRule().clear();
				getSubstitutionRule().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE_TYPE__ID:
				setId(ID_EDEFAULT);
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__INDEX:
				setIndex(INDEX_EDEFAULT);
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				unsetUsePreviousMatchSubstitutionAsDefault();
				return;
			case ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE:
				getSubstitutionRule().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE_TYPE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ParserPackage.RULE_ATTRIBUTE_TYPE__INDEX:
				return INDEX_EDEFAULT == null ? index != null : !INDEX_EDEFAULT.equals(index);
			case ParserPackage.RULE_ATTRIBUTE_TYPE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				return isSetUsePreviousMatchSubstitutionAsDefault();
			case ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE:
				return substitutionRule != null && !substitutionRule.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", index: ");
		result.append(index);
		result.append(", name: ");
		result.append(name);
		result.append(", usePreviousMatchSubstitutionAsDefault: ");
		if (usePreviousMatchSubstitutionAsDefaultESet) result.append(usePreviousMatchSubstitutionAsDefault); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //RuleAttributeTypeImpl
