/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.sensor.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Static Parser Sensor Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.StaticParserSensorTypeImpl#getDirectory <em>Directory</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.StaticParserSensorTypeImpl#getFileName <em>File Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.StaticParserSensorTypeImpl#getParserClassName <em>Parser Class Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class StaticParserSensorTypeImpl extends SensorBaseTypeImpl implements StaticParserSensorType {
	/**
	 * The default value of the '{@link #getDirectory() <em>Directory</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDirectory()
	 * @generated
	 * @ordered
	 */
	protected static final String DIRECTORY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDirectory() <em>Directory</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDirectory()
	 * @generated
	 * @ordered
	 */
	protected String directory = DIRECTORY_EDEFAULT;

	/**
	 * The default value of the '{@link #getFileName() <em>File Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFileName()
	 * @generated
	 * @ordered
	 */
	protected static final String FILE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFileName() <em>File Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFileName()
	 * @generated
	 * @ordered
	 */
	protected String fileName = FILE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getParserClassName() <em>Parser Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParserClassName()
	 * @generated
	 * @ordered
	 */
	protected static final String PARSER_CLASS_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParserClassName() <em>Parser Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParserClassName()
	 * @generated
	 * @ordered
	 */
	protected String parserClassName = PARSER_CLASS_NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StaticParserSensorTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SensorPackage.eINSTANCE.getStaticParserSensorType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDirectory() {
		return directory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDirectory(String newDirectory) {
		String oldDirectory = directory;
		directory = newDirectory;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.STATIC_PARSER_SENSOR_TYPE__DIRECTORY, oldDirectory, directory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFileName(String newFileName) {
		String oldFileName = fileName;
		fileName = newFileName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.STATIC_PARSER_SENSOR_TYPE__FILE_NAME, oldFileName, fileName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getParserClassName() {
		return parserClassName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParserClassName(String newParserClassName) {
		String oldParserClassName = parserClassName;
		parserClassName = newParserClassName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.STATIC_PARSER_SENSOR_TYPE__PARSER_CLASS_NAME, oldParserClassName, parserClassName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SensorPackage.STATIC_PARSER_SENSOR_TYPE__SENSOR_PROPERTY:
					return ((InternalEList)getSensorProperty()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__SENSOR_PROPERTY:
				return getSensorProperty();
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__DIRECTORY:
				return getDirectory();
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__FILE_NAME:
				return getFileName();
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__PARSER_CLASS_NAME:
				return getParserClassName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__SENSOR_PROPERTY:
				getSensorProperty().clear();
				getSensorProperty().addAll((Collection)newValue);
				return;
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__DIRECTORY:
				setDirectory((String)newValue);
				return;
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__FILE_NAME:
				setFileName((String)newValue);
				return;
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__PARSER_CLASS_NAME:
				setParserClassName((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__SENSOR_PROPERTY:
				getSensorProperty().clear();
				return;
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__DIRECTORY:
				setDirectory(DIRECTORY_EDEFAULT);
				return;
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__FILE_NAME:
				setFileName(FILE_NAME_EDEFAULT);
				return;
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__PARSER_CLASS_NAME:
				setParserClassName(PARSER_CLASS_NAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__SENSOR_PROPERTY:
				return sensorProperty != null && !sensorProperty.isEmpty();
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__DIRECTORY:
				return DIRECTORY_EDEFAULT == null ? directory != null : !DIRECTORY_EDEFAULT.equals(directory);
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__FILE_NAME:
				return FILE_NAME_EDEFAULT == null ? fileName != null : !FILE_NAME_EDEFAULT.equals(fileName);
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__PARSER_CLASS_NAME:
				return PARSER_CLASS_NAME_EDEFAULT == null ? parserClassName != null : !PARSER_CLASS_NAME_EDEFAULT.equals(parserClassName);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (directory: ");
		result.append(directory);
		result.append(", fileName: ");
		result.append(fileName);
		result.append(", parserClassName: ");
		result.append(parserClassName);
		result.append(')');
		return result.toString();
	}

} //StaticParserSensorTypeImpl
