/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.sensor.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage
 * @generated
 */
public class SensorSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static SensorPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorSwitch() {
		if (modelPackage == null) {
			modelPackage = SensorPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case SensorPackage.SENSOR_PROPERTY_TYPE: {
					SensorPropertyType sensorPropertyType = (SensorPropertyType)theEObject;
					Object result = caseSensorPropertyType(sensorPropertyType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case SensorPackage.SENSOR_BASE_TYPE: {
					SensorBaseType sensorBaseType = (SensorBaseType)theEObject;
					Object result = caseSensorBaseType(sensorBaseType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case SensorPackage.SINGLE_FILE_SENSOR_TYPE: {
					SingleFileSensorType singleFileSensorType = (SingleFileSensorType)theEObject;
					Object result = caseSingleFileSensorType(singleFileSensorType);
					if (result == null) result = caseSensorBaseType(singleFileSensorType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case SensorPackage.ADAPTER_CBE_SENSOR_TYPE: {
					AdapterCBESensorType adapterCBESensorType = (AdapterCBESensorType)theEObject;
					Object result = caseAdapterCBESensorType(adapterCBESensorType);
					if (result == null) result = caseSensorBaseType(adapterCBESensorType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case SensorPackage.STATIC_PARSER_SENSOR_TYPE: {
					StaticParserSensorType staticParserSensorType = (StaticParserSensorType)theEObject;
					Object result = caseStaticParserSensorType(staticParserSensorType);
					if (result == null) result = caseSensorBaseType(staticParserSensorType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case SensorPackage.SENSOR_CONFIG_TYPE: {
					SensorConfigType sensorConfigType = (SensorConfigType)theEObject;
					Object result = caseSensorConfigType(sensorConfigType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Property Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSensorPropertyType(SensorPropertyType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Base Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Base Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSensorBaseType(SensorBaseType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Single File Sensor Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Single File Sensor Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSingleFileSensorType(SingleFileSensorType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Adapter CBE Sensor Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Adapter CBE Sensor Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAdapterCBESensorType(AdapterCBESensorType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Static Parser Sensor Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Static Parser Sensor Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseStaticParserSensorType(StaticParserSensorType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSensorConfigType(SensorConfigType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //SensorSwitch
