/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen;


/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TestgenException extends Exception
{
	private Exception exception;
	
	public TestgenException (String message)
	{
		super(message);
	}

	public TestgenException (String message, Exception exception)
	{
		super(message);
		this.exception = exception;
	}

	public String getMessage ()
	{
		String message = super.getMessage();	
		if (message == null && exception != null)
			return exception.getMessage();
		else
			return message;
	}

	public void dumpMessages (java.io.PrintStream stream)
	{
		String message = super.getMessage();
		if (message != null)
			stream.print(message);
		stream.print(": ");
		if (exception != null)
			stream.print(exception.getMessage());
		stream.println();
	}
}
