/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Monitor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl#getNodes <em>Nodes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl#getCorrelationContainerProxies <em>Correlation Container Proxies</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCMonitorImpl extends EObjectImpl  implements TRCMonitor {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final double START_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected double startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected static final double STOP_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected double stopTime = STOP_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getNodes() <em>Nodes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNodes()
	 * @generated
	 * @ordered
	 */
	protected EList nodes = null;

	/**
	 * The cached value of the '{@link #getCorrelationContainerProxies() <em>Correlation Container Proxies</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainerProxies()
	 * @generated
	 * @ordered
	 */
	protected EList correlationContainerProxies = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCMonitorImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return HierarchyPackage.eINSTANCE.getTRCMonitor();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName)
	{
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_MONITOR__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStartTime()
	{
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartTime(double newStartTime)
	{
		double oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_MONITOR__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStopTime()
	{
		return stopTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStopTime(double newStopTime)
	{
		double oldStopTime = stopTime;
		stopTime = newStopTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_MONITOR__STOP_TIME, oldStopTime, stopTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getNodes()
	{
		if (nodes == null) {
			nodes = new EObjectWithInverseResolvingEList(TRCNode.class, this, HierarchyPackage.TRC_MONITOR__NODES, HierarchyPackage.TRC_NODE__MONITOR);
		}
		return nodes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getCorrelationContainerProxies()
	{
		if (correlationContainerProxies == null) {
			correlationContainerProxies = new EObjectContainmentWithInverseEList(CorrelationContainerProxy.class, this, HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES, HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR);
		}
		return correlationContainerProxies;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_MONITOR__NODES:
					return ((InternalEList)getNodes()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES:
					return ((InternalEList)getCorrelationContainerProxies()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_MONITOR__NODES:
					return ((InternalEList)getNodes()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES:
					return ((InternalEList)getCorrelationContainerProxies()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_MONITOR__NAME:
				return getName();
			case HierarchyPackage.TRC_MONITOR__START_TIME:
				return new Double(getStartTime());
			case HierarchyPackage.TRC_MONITOR__STOP_TIME:
				return new Double(getStopTime());
			case HierarchyPackage.TRC_MONITOR__NODES:
				return getNodes();
			case HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES:
				return getCorrelationContainerProxies();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_MONITOR__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.TRC_MONITOR__START_TIME:
				setStartTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_MONITOR__STOP_TIME:
				setStopTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_MONITOR__NODES:
				getNodes().clear();
				getNodes().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES:
				getCorrelationContainerProxies().clear();
				getCorrelationContainerProxies().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_MONITOR__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_MONITOR__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_MONITOR__STOP_TIME:
				setStopTime(STOP_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_MONITOR__NODES:
				getNodes().clear();
				return;
			case HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES:
				getCorrelationContainerProxies().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_MONITOR__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.TRC_MONITOR__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case HierarchyPackage.TRC_MONITOR__STOP_TIME:
				return stopTime != STOP_TIME_EDEFAULT;
			case HierarchyPackage.TRC_MONITOR__NODES:
				return nodes != null && !nodes.isEmpty();
			case HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES:
				return correlationContainerProxies != null && !correlationContainerProxies.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", stopTime: ");
		result.append(stopTime);
		result.append(')');
		return result.toString();
	}

} //TRCMonitorImpl
