/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IProcessConsole;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * @author ddreakfo
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class ExecutorStub extends ExecutionComponentStub implements IExecutor {
	
	private String executionResultLocation = null;
	private String executionResultName = null;
	
	public ExecutorStub() {
		super();
	}
	
	public ExecutorStub(IExecutionComponent delegate){
		super(delegate);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#launch()
	 */
	public void launch() throws ExecutionComponentStateException {	
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "launch");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#kill()
	 */
	public void kill() throws ExecutionComponentStateException {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "kill");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	/**
	 * Associate an executable object with this executor.
	 * There is a local and a remote portion of this operation.
	 *  
	 * @see org.eclipse.hyades.execution.core.IExecutor#setExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject)
	 */
	public void setExecutableObject(IExecutableObject theExecutableObject) throws ExecutionComponentStateException {
		// Set the local values in case we decide to add a getExecutableObject().
		((IExecutor)delegate).setExecutableObject(theExecutableObject);
		
		ReturnData invokeRtn = delegateRemoteCall(
			new Class[]{IExecutableObject.class},
			new Object[]{theExecutableObject},
			"setExecutableObject");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}

		// Do this after both (the local and the remote) portions of
		// setExecutableObject() have been completed.
		theExecutableObject.setExecutor(this);
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getExecutableObject()
	 */
	public IExecutableObject getExecutableObject()
	{
		return ((IExecutor)delegate).getExecutableObject();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#getProcessConsole()
	 */
	public IProcessConsole getProcessConsole() throws ExecutionComponentStateException {
		// TODO Auto-generated method stub
		return null;
	}
		
	/**
	 * Create an <code>IExecutableObject</code> instance that is compatible
	 * with this executor.
	 * 
	 * The implementation of this method differs from the
	 * norm, as no responsibilities are delegated to the delegate object.
	 * Instead, the creation of the executable object is handled completely
	 * by the stub/skeleton combination.
	 * 
	 * @return a <code>JavaTaskExcutableObjectStub</code> 
	 */
	public IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException {
		
		// We could configure the factory to return the expected type of
		// executable object here, instead of in the Test Tool initialization
		// code. I'm not sure where it fits best.
		ExecutionComponentFactoryImpl factory = (ExecutionComponentFactoryImpl)ExecutionComponentFactoryImpl.getInstance(
			getSessionContext());
		IRemoteObject remoteObj = factory.createRemoteObjectByType(classname);
		if ( !(remoteObj instanceof IExecutableObject) )
			throw new ClassCastException("Component factory returned an incorrect type; expected an IExecutableObject");
		return (IExecutableObject)remoteObj;
	}
	
	/**
	 * @return
	 */
	public String getExecutionResultLocation() {
		return executionResultLocation;
	}

	/**
	 * @return
	 */
	public String getExecutionResultName() {
		return executionResultName;
	}

	/**
	 * @param string
	 */
	public void setExecutionResultLocation(String string) {
		executionResultLocation = string;
	}

	/**
	 * @param string
	 */
	public void setExecutionResultName(String string) {
		executionResultName = string;
	}

}
