/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DeleteColumnAction extends SelectionProviderAction {
	private DatapoolTable table;

	public DeleteColumnAction(ISelectionProvider viewer, DatapoolTable table)
	{
		super(viewer, TestUIPlugin.getString("DEL_COL_TEXT"));
		setDescription(TestUIPlugin.getString("DEL_COL_LDESC"));
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.DEL_COL_ACT);
		this.table = table;
	}

	public void run()
	{
		if (table != null)
			table.deleteColumn();
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}
	
}
