/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DatapoolTableUtil {

	private static final String TAG_DATA = "data"; //$NON-NLS-1$
	private static final String TAG_RECORD = "record"; //$NON-NLS-1$
	private static final String TAG_VARIABLE = "variable"; //$NON-NLS-1$
	private static final String TAG_VARIABLE_INDEX = "variableIndex"; //$NON-NLS-1$
	private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass"; //$NON-NLS-1$

	private Table table = null;
	
	public DatapoolTableUtil(Table table)
	{
		this.table = table;
	}

	public int getColumnCount()
	{
		int counter = 0;
		for(int i = 0; i < table.getColumnCount(); i++)
		{
			TableColumn tableColumn = table.getColumn(i);
			if(tableColumn.getWidth() != 0)
				counter++;	
		}
		return counter;
	}

	// Assumes column has been added
	public void insertColumn(TableColumn tableColumn, int insertionIndex)
	{
		int sourceIndex = findColumnIndex(tableColumn);
		// Add to rowData
		for(int i = 0; i < table.getItemCount(); i++)
		{
			TableItem tableItem = table.getItem(i);	
			DPLCell[] rowData = (DPLCell[])tableItem.getData(TAG_DATA);
			DPLCell[] newRowData = new DPLCell[table.getColumnCount() - 1];
			String[] newRowContext = new String[table.getColumnCount()];
			newRowContext[0] = tableItem.getText(0);
			for(int j = 0; j < newRowData.length; j++)
			{
				if(j < insertionIndex)
				{
					newRowData[j] = rowData[j];
					newRowContext[j+1] = tableItem.getText(j+1);
				}
				if(j > insertionIndex)
				{
					newRowData[j] = rowData[j - 1];
					newRowContext[j] = tableItem.getText(j);
				}
			}
			tableItem.setData(TAG_DATA, newRowData);
			tableItem.setText(newRowContext);
		}
		
		if(sourceIndex >= 0)
		{
			if(sourceIndex != insertionIndex + 1)
			{
				moveColumn(sourceIndex, insertionIndex + 1);
				TableColumn sourceColumn = table.getColumn(sourceIndex);
				TableColumn insertedColumn = table.getColumn(insertionIndex + 1);
				sourceColumn.setWidth(100);
				sourceColumn.setResizable(true);
				insertedColumn.setWidth(100);
				insertedColumn.setResizable(true);
			}
		}
		else
			throw new IllegalArgumentException();
	}

	public void deleteColumn(int columnIndex)
	{
		TableColumn tableColumn = null;
		if(columnIndex + 1 == getColumnCount())
			tableColumn = table.getColumn(columnIndex);
		else
		{
			moveColumn(columnIndex, getColumnCount()-1);
			tableColumn = table.getColumn(getColumnCount() - 1);
		}	
		if(tableColumn != null)
		{	
			tableColumn.setText(new String());
			int movedColumnIndex = findColumnIndex(tableColumn);
			for(int i = 0; i < table.getItemCount(); i++)
			{
				TableItem tableItem = table.getItem(i);	
				DPLCell[] rowData = (DPLCell[])tableItem.getData(TAG_DATA);
				rowData[movedColumnIndex - 1] = null;
				tableItem.setText(movedColumnIndex, new String());
			}
			tableColumn.setResizable(false);
			tableColumn.setWidth(0);
		}

	}
	
	private int findColumnIndex(TableColumn column)
	{
		for(int i = 0; i < table.getColumnCount(); i++)
		{
			if(table.getColumn(i).equals(column))
				return i;
		}
		return -1;
	}
		
	// replace target with source
	private void replaceColumn(int sourceColumnIndex, int targetColumnIndex)
	{
		TableColumn sourceColumn = table.getColumn(sourceColumnIndex);
		String sourceName = sourceColumn.getText();
		DPLVariable sourceVariable = (DPLVariable)sourceColumn.getData(TAG_VARIABLE);

		TableColumn targetColumn = table.getColumn(targetColumnIndex);		
		
		targetColumn.setText(sourceName);		
		targetColumn.setData(TAG_VARIABLE, sourceVariable);
		
		for(int i = 0; i < table.getItemCount(); i++)
		{
			TableItem tableItem = table.getItem(i);	
			
			DPLCell[] rowData = (DPLCell[])tableItem.getData(TAG_DATA);
			String[] newRowContext = new String[table.getColumnCount()];
			newRowContext[0] = tableItem.getText(0);
			for(int j = 0; j < rowData.length; j++)
				newRowContext[j+1] = tableItem.getText(j);
			newRowContext[targetColumnIndex + 1] = tableItem.getText(sourceColumnIndex + 1);
			DPLCell sourceCell = rowData[sourceColumnIndex];
			rowData[targetColumnIndex] = sourceCell;
			tableItem.setData(TAG_DATA, rowData);
			tableItem.setText(newRowContext);
		}	
	}
	
	private void swapColumn(int sourceColumnIndex, int targetColumnIndex)
	{
		TableColumn sourceColumn = table.getColumn(sourceColumnIndex);
		String sourceName = sourceColumn.getText();
		DPLVariable sourceVariable = (DPLVariable)sourceColumn.getData(TAG_VARIABLE);

		TableColumn targetColumn = table.getColumn(targetColumnIndex);		
		String targetName = targetColumn.getText();
		DPLVariable targetVariable = (DPLVariable)targetColumn.getData(TAG_VARIABLE);
		
		sourceColumn.setText(targetName);
		sourceColumn.setData(TAG_VARIABLE, targetVariable);

		targetColumn.setText(sourceName);		
		targetColumn.setData(TAG_VARIABLE, sourceVariable);
		
		for(int i = 0; i < table.getItemCount(); i++)
		{
			TableItem tableItem = table.getItem(i);	
			
			DPLCell[] rowData = (DPLCell[])tableItem.getData(TAG_DATA);
			String[] newRowContext = new String[table.getColumnCount()];
			newRowContext[0] = tableItem.getText(0);
			for(int j = 0; j < rowData.length; j++)
				newRowContext[j+1] = tableItem.getText(j+1);
			newRowContext[sourceColumnIndex] = tableItem.getText(targetColumnIndex);
			newRowContext[targetColumnIndex] = tableItem.getText(sourceColumnIndex);
			DPLCell sourceCell = rowData[sourceColumnIndex-1];
			DPLCell targetCell = rowData[targetColumnIndex-1];
			rowData[sourceColumnIndex-1] = targetCell;
			rowData[targetColumnIndex-1] = sourceCell;
			tableItem.setData(TAG_DATA, rowData);
			tableItem.setText(newRowContext);
		}			
	}

	public void moveColumn(int sourceColumnIndex, int targetColumnIndex)
	{
		int numToSwap = 0;
		if(sourceColumnIndex < targetColumnIndex)
			numToSwap = targetColumnIndex - sourceColumnIndex;
		else
			numToSwap = sourceColumnIndex - targetColumnIndex;

		TableColumn sourceColumn = table.getColumn(sourceColumnIndex);
		String sourceName = sourceColumn.getText();
		DPLVariable sourceVariable = (DPLVariable)sourceColumn.getData(TAG_VARIABLE);

		for(int i = 0; i < numToSwap; i++)
		{
			TableColumn shiftColumn = null;
			TableColumn targetColumn = null;

			if(sourceColumnIndex < targetColumnIndex)
			{
				shiftColumn = table.getColumn(sourceColumnIndex + i + 1);
				targetColumn = table.getColumn(sourceColumnIndex + i);
			}
			else
			{
				shiftColumn = table.getColumn(sourceColumnIndex - i - 1);
				targetColumn = table.getColumn(sourceColumnIndex - i);
			}
			
			String shiftName = shiftColumn.getText();
			DPLVariable shiftVariable = (DPLVariable)shiftColumn.getData(TAG_VARIABLE);

			String targetName = targetColumn.getText();
			DPLVariable targetVariable = (DPLVariable)targetColumn.getData(TAG_VARIABLE);

			targetColumn.setText(shiftName);
			targetColumn.setData(TAG_VARIABLE, shiftVariable);
		}
		
		TableColumn targetColumn = table.getColumn(targetColumnIndex);		
		targetColumn.setText(sourceName);		
		targetColumn.setData(TAG_VARIABLE, sourceVariable);

		for(int i = 0; i < table.getItemCount(); i++)
		{
			TableItem tableItem = table.getItem(i);	
			
			DPLCell[] rowData = (DPLCell[])tableItem.getData(TAG_DATA);
			DPLCell sourceCell = rowData[sourceColumnIndex - 1];
			String sourceText = tableItem.getText(sourceColumnIndex);
			
			for(int j = 0; j < numToSwap; j++)
			{
				if(sourceColumnIndex < targetColumnIndex)
				{
					DPLCell shiftCell = rowData[sourceColumnIndex + j];
					String shiftText = tableItem.getText(sourceColumnIndex + j + 1);
					
					rowData[sourceColumnIndex + j - 1] = shiftCell;
					tableItem.setText(sourceColumnIndex + j, shiftText);
				}
				else
				{
					DPLCell shiftCell = rowData[sourceColumnIndex - j - 2];
					String shiftText = tableItem.getText(sourceColumnIndex - j - 1);
				
					rowData[sourceColumnIndex - j - 1] = shiftCell;
					tableItem.setText(sourceColumnIndex - j, shiftText);														
				}
			}
			
			tableItem.setText(targetColumnIndex, sourceText);
			rowData[targetColumnIndex - 1] = sourceCell;

			tableItem.setData(TAG_DATA, rowData);
		}					
	}
	
	private void swapRow(int sourceRowIndex, int targetRowIndex)
	{
		TableItem sourceItem = table.getItem(sourceRowIndex);
		String[] sourceRowContext = new String[table.getColumnCount()];
		for(int i = 0; i < table.getColumnCount(); i++)
		{
			sourceRowContext[i] = sourceItem.getText(i);
		}	
		DPLCell[] sourceRowData = (DPLCell[])sourceItem.getData(TAG_DATA);
		DPLRecord sourceRecord = (DPLRecord)sourceItem.getData(TAG_RECORD);
		DPLEquivalenceClass sourceEquivalenceClass = (DPLEquivalenceClass)sourceItem.getData(TAG_EQUIVALENCE_CLASS);
				
		TableItem targetItem = table.getItem(targetRowIndex);
		String[] targetRowContext = new String[table.getColumnCount()];
		for(int i = 0; i < table.getColumnCount(); i++)
		{
			targetRowContext[i] = targetItem.getText(i);
		}
		DPLCell[] targetRowData = (DPLCell[])targetItem.getData(TAG_DATA);
		DPLRecord targetRecord = (DPLRecord)targetItem.getData(TAG_RECORD);
		DPLEquivalenceClass targetEquivalenceClass = (DPLEquivalenceClass)targetItem.getData(TAG_EQUIVALENCE_CLASS);

		sourceItem.setText(targetRowContext);
		sourceItem.setData(TAG_DATA, targetRowData);
		sourceItem.setData(TAG_RECORD, targetRecord);
		sourceItem.setData(TAG_EQUIVALENCE_CLASS, targetEquivalenceClass);
		
		targetItem.setText(sourceRowContext);
		targetItem.setData(TAG_DATA, sourceRowData);
		targetItem.setData(TAG_RECORD, sourceRecord);
		targetItem.setData(TAG_EQUIVALENCE_CLASS, sourceEquivalenceClass);
	}
	
	public void moveRow(int sourceRowIndex, int targetRowIndex)
	{
		int numToSwap = 0;
		if(sourceRowIndex < targetRowIndex)
			numToSwap = targetRowIndex - sourceRowIndex;
		else
			numToSwap = sourceRowIndex - targetRowIndex;
		
		TableItem sourceItem = table.getItem(sourceRowIndex);
		String[] sourceRowContext = new String[table.getColumnCount()];
		for(int i = 0; i < table.getColumnCount(); i++)
		{
			sourceRowContext[i] = sourceItem.getText(i);
		}	
		DPLCell[] sourceRowData = (DPLCell[])sourceItem.getData(TAG_DATA);
		DPLRecord sourceRecord = (DPLRecord)sourceItem.getData(TAG_RECORD);
		DPLEquivalenceClass sourceEquivalenceClass = (DPLEquivalenceClass)sourceItem.getData(TAG_EQUIVALENCE_CLASS);

		for(int i = 0; i < numToSwap; i++)
		{
			TableItem shiftItem = null;
			TableItem targetItem = null;

			if(sourceRowIndex < targetRowIndex)
			{
				shiftItem = table.getItem(sourceRowIndex + i + 1);
				targetItem = table.getItem(sourceRowIndex + i);
			}
			else
			{
				shiftItem = table.getItem(sourceRowIndex - i - 1);
				targetItem = table.getItem(sourceRowIndex - i);
			}
			
			String[] shiftRowContext = new String[table.getColumnCount()];
			for(int j = 0; j < table.getColumnCount(); j++)
			{
				shiftRowContext[j] = shiftItem.getText(j);
			}	
			DPLCell[] shiftRowData = (DPLCell[])shiftItem.getData(TAG_DATA);
			DPLRecord shiftRecord = (DPLRecord)shiftItem.getData(TAG_RECORD);
			DPLEquivalenceClass shiftEquivalenceClass = (DPLEquivalenceClass)shiftItem.getData(TAG_EQUIVALENCE_CLASS);
			
			targetItem.setText(shiftRowContext);
			targetItem.setData(TAG_DATA, shiftRowData);
			targetItem.setData(TAG_RECORD, shiftRecord);
			targetItem.setData(TAG_EQUIVALENCE_CLASS, shiftEquivalenceClass);
		}
		
		TableItem targetItem = table.getItem(targetRowIndex);
		targetItem.setText(sourceRowContext);
		targetItem.setData(TAG_DATA, sourceRowData);
		targetItem.setData(TAG_RECORD, sourceRecord);
		targetItem.setData(TAG_EQUIVALENCE_CLASS, sourceEquivalenceClass);
	}
}
