package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * <code>IGraphicTypeConstants</code> interface defines constants
 * denoting the known generated types. Users should extend this to add
 * their own types if it is necessary to distinguish types.
 *  
 * @version 1.7.1.4
 */ 
public interface IGraphicTypeConstants {	
	/**
	 * The generated type is a line chart.
	 */
	String LINE_CHART=	  "line";
	
	/**
	 * The generated type is a area chart.
	 */
	String AREA_CHART=	  "area";
	
	/**
	 * The generated type is a scatter plot chart.
	 */
	String SCATTER_CHART=	  "scatter";
	
	/**
	 * The generated type is a pie chart.
	 */
	String PIE_CHART=	  "pie";
	
	/**
	 * The generated type is a bar (column) chart.
	 */
	String BAR_CHART=	  "bar";
	
	/**
	 * The generated type is a stacked bar (column) chart.
	 */
	String STACKBAR_CHART= "stack";
	
	/**
	 * The generated type is a group bar (column) chart.
	 */
	String GROUPBAR_CHART= "group";
	
	/**
	 * The generated type is a meter.
	 */
	String METER=		  "meter";
}

