/*
 * Created on Jan 7, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import org.eclipse.hyades.log.ui.internal.actions.LogNavigatorFilterAction;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class FilterActionGroup extends ActionGroup {
	private LogNavigatorFilterAction fShowNodes;
	private LogNavigator navigator;

	public FilterActionGroup(LogNavigator navigator) {
		super();
		
		this.navigator = navigator;
		makeActions();
	}

	protected void makeActions() {
		
		fShowNodes= new LogNavigatorFilterAction(navigator, UIPlugin.getResourceString("STR_TOOL_BAR_NODES"), TraceConstants.FILTER_NODE
						, navigator.getSettings().getBoolean(TraceConstants.SHOW_NODE_KEY));
		fShowNodes.setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_NODE));

	}

	public void fillActionBars(IActionBars actionBars) {
		IMenuManager menu = actionBars.getMenuManager();
		IMenuManager submenu =
			new MenuManager("Filter"); //$NON-NLS-1$
		menu.add(submenu);
		submenu.add(fShowNodes);
	}

	public void dispose()
	{
		navigator = null;
		fShowNodes = null;
    	
	}
    
	public void updateActionBars() {
		
		fShowNodes.setChecked(navigator.getSettings().getBoolean(TraceConstants.SHOW_NODE_KEY), false);
	}

}
