/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/*
 * Created on Nov 3, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.TraceLogActionGroup;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.OpenFileAction;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogNavigatorActionGroup extends TraceLogActionGroup {

	private OpenFileAction fOpenFileAction;
	private NewActionGroup newActionGroup;
	private FilterActionGroup filterActionGroup;
	
	/**
	 * Constructor for LogNavigatorActionGroup
	 * @param logNavigator
	 */
	public LogNavigatorActionGroup(LogNavigator logNavigator)
	{
		super(logNavigator);
	}

	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#dispose()
	 */
	public void dispose()
	{
		newActionGroup.dispose();
		newActionGroup = null;
		fOpenFileAction = null;
		super.dispose();
		
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#setContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setContext(ActionContext context)
	{
		if(newActionGroup!=null)
			newActionGroup.setContext(context);
		
		super.setContext(context);
		
	}


	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		
		newActionGroup.fillContextMenu(menu);
		IStructuredSelection selection = (IStructuredSelection)getContext().getSelection();
		boolean sameClass = false;
		boolean multiSelection = (selection.size() > 1);
		if (multiSelection)
			sameClass = areSameClass(selection);
		
		Object sel = null;
		if(selection.iterator().hasNext()){
			sel = selection.iterator().next();
		}
		
		if(sel!=null){
			if (sel instanceof LogicalFolder)
			{				
				
			}else if(sel instanceof TRCAgentProxy)
			{
						
				if (!multiSelection || sameClass) {
					menu.add(fMonitorGrp);
					menu.add(fGCGroup);
					menu.add(fAttachGrp);				
					
				}
				
				if(!multiSelection)
				{
					menu.add(fNewSnapshotGrp);				
					menu.add(fTerminateGrp);
					menu.add(new Separator(GROUP_ADD_VIEWS));		
					addViews(menu, sel);
				}
				menu.add(new Separator(GROUP_DELETE));
				menu.appendToGroup(GROUP_DELETE,fDeleteAction);
		
				menu.add(new Separator(GROUP_SAVE));
				menu.appendToGroup(GROUP_SAVE,fSaveToFile);
				
		    	
			}else if(sel instanceof CorrelationContainerProxy){
				if(!multiSelection)
				{
					menu.add(new Separator(GROUP_ADD_VIEWS));		
					addViews(menu, sel);
				}
				menu.add(new Separator(GROUP_DELETE));
				menu.appendToGroup(GROUP_DELETE,fDeleteAction);
		
				menu.add(new Separator(GROUP_SAVE));
				menu.appendToGroup(GROUP_SAVE,fSaveToFile);
			
			}
			else if(sel instanceof IFile){
				menu.add(new Separator(GROUP_OPEN));
				menu.appendToGroup(GROUP_OPEN, fOpenFileAction);
				fOpenFileAction.selectionChanged((IStructuredSelection)getContext().getSelection());
				menu.add(new Separator(GROUP_DELETE));
				menu.appendToGroup(GROUP_DELETE,fDeleteAction);
		
				menu.add(new Separator(GROUP_SAVE));
				menu.appendToGroup(GROUP_SAVE,fSaveToFile);
			
			}else if(sel instanceof TRCNode){				
				menu.add(new Separator(GROUP_ADD_VIEWS));			
				addViews(menu, sel); 
				menu.add(fRefreshGrp);			
			}
		}
	
		menu.add(new Separator(IWorkbenchActionConstants.GROUP_REORGANIZE));

		menu.add(new Separator(GROUP_REFRESH));
		menu.appendToGroup(GROUP_REFRESH,fRefreshTree);
		menu.appendToGroup(GROUP_REFRESH,fRefreshLocal);

		if (!multiSelection) {
			
			menu.add(new Separator(GROUP_OPEN_PROPERTY));
	
			if (sel instanceof TRCAgentProxy) {
				if (((TRCAgentProxy) sel).getType().equals(TraceConstants.LOG_AGENT_TYPE)) {
					menu.appendToGroup(GROUP_OPEN_PROPERTY,fOpenLogAgentAction);
				}
			}else if (sel instanceof TRCNode) {
				menu.appendToGroup(GROUP_OPEN_PROPERTY,fOpenNodeAction);
			}	
		}

		menu.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
		fImportActionGroup.fillContextMenu(menu);
		
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (08/24/2000 2:06:10 PM)
	 * @param menu com.ibm.jface.MenuManager
	 */
	protected void addViews(IMenuManager menu, Object obj) {
		
		if(obj == null || !(obj instanceof EObject))
		  return;

		MenuManager popup = new MenuManager(UIPlugin.getResourceString("MENU_MANAGER"));
		menu.appendToGroup(GROUP_ADD_VIEWS,popup);
		  
		if(obj instanceof TRCAgentProxy)
		{
			IAction[] actions = getViewMappingForType(((TRCAgentProxy)obj).getType());
			for(int idx=0; idx<actions.length; idx++)
			{
				if(actions[idx] != null)
				   popup.add(actions[idx]);
			}
		}else if(obj instanceof CorrelationContainerProxy){
			IAction[] actions = getViewMappingForType(TraceConstants.LOG_AGENT_TYPE);
			for(int idx=0; idx<actions.length; idx++)
			{
				if(actions[idx] != null)
				   popup.add(actions[idx]);
			}
			
		}else if(obj instanceof TRCNode)
		{
			IAction[] actions = getViewMappingForType(TraceConstants.HOST_TYPE);
			for(int idx=0; idx<actions.length; idx++)
			{
				if(actions[idx] != null)
				   popup.add(actions[idx]);
			}
			
			List typesList = new ArrayList();
			List processes = ((TRCNode) obj).getProcessProxies();
			for(int i=0; i<processes.size(); i++)
			{
				TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
				List agents = process.getAgentProxies();
				
				for(int j=0; j<agents.size(); j++)
				{
					TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
					
					if(typesList.contains(agent.getType()))
					  continue; //actions already added to the popup
					
					typesList.add(agent.getType());
					actions = getViewMappingForType(agent.getType());
					if(actions.length > 0)
					{//add the actions to the popup
						popup.add(new Separator());						
						for(int k=0; k<actions.length; k++)
							popup.add(actions[k]);
					}
				}
			}
			
		}

	}
	
	
		
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public void fillActionBars(IActionBars actionBars)
	{		
		if(newActionGroup!=null){
			newActionGroup.fillActionBars(actionBars);
		}
		if(filterActionGroup!=null){
			filterActionGroup.fillActionBars(actionBars);
		}
		super.fillActionBars(actionBars);		
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#updateActionBars()
	 */
	public void updateActionBars()
	{
		filterActionGroup.updateActionBars();
	}
	
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#handleKeyPressed(org.eclipse.swt.events.KeyEvent)
	 */
	public void handleKeyPressed(KeyEvent event)
	{

		super.handleKeyPressed(event);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions() {		
		super.createActions();
		fOpenFileAction = new OpenFileAction(getNavigator().getSite().getPage());		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActionGroups()
	 */
	protected void createActionGroups() {
		newActionGroup = new NewActionGroup((LogNavigator)getNavigator());
		filterActionGroup = new FilterActionGroup((LogNavigator)getNavigator());		
	}

}
