/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.LargeLogSupportUI;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * CONTEXT_ID llsp0000 for Large log support preference page
 */
public class LargeLogSupportPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private LargeLogSupportUI largeLogSupportUI;

	public LargeLogSupportPreferencePage() {
		super();
		setPreferenceStore(LogUIPlugin.getDefault().getPreferenceStore());
	}

	protected Control createContents(Composite parent) {
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			LogUIPlugin.getPluginId() + ".llsp0000");

		largeLogSupportUI = new LargeLogSupportUI();
		return largeLogSupportUI.createControl(parent);
	}
	/**
	 * Returns preference store that belongs to the our plugin. This is
	 * important because we want to store our preferences separately from the
	 * desktop.
	 * 
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return LogUIPlugin.getDefault().getPreferenceStore();
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		largeLogSupportUI.initializeValues(true);
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 * 
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		largeLogSupportUI.storeValues();
		HierarchyPlugin.getPlugin().savePluginPreferences();
		return true;
	}

}
