/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * Insert the type's description here.
 * Creation date: (3/7/2001 1:44:48 PM)
 * @author: Administrator
 */
public class FiltersDialog extends Dialog //implements SelectionListener
{
	private CBEAdvFilterUI _filters;
	private static final int _restoreDefaultsButtonId = IDialogConstants.CLIENT_ID + 1;

	private java.lang.String _title;
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage com.ibm.swt.graphics.Image
	 */
	public FiltersDialog(Shell shell, String windowTitle, Image windowImage) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 0;
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.widthHint = 500;
		result.setLayoutData(data);

		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		_filters =  new CBEAdvFilterUI();
		_filters.createControl(result);
		_filters.initializeValues(false);

		WorkbenchHelp.setHelp(result, ContextIds.ACTLOG_VIEW_DIALOG_FILTER);

		return result;
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(
			parent,
			_restoreDefaultsButtonId,
			LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"),
			false);
		super.createButtonsForButtonBar(parent);
	}
	protected void buttonPressed(int buttonId) {
		if (buttonId == _restoreDefaultsButtonId) {
			_filters.initializeValues(true);
		} else {
			super.buttonPressed(buttonId);
		}

	}
	/**
	 * Notifies that the ok button of this dialog has been pressed.
	 * <p>
	 * The default implementation of this framework method sets
	 * this dialog's return code to <code>Window.OK</code>
	 * and closes the dialog. Subclasses may override.
	 * </p>
	 */
	protected void okPressed() {
		_filters.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
		LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_ADV_CHANGE, this));
		super.okPressed();
	}
}