/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class LargeLogSupportUI implements SelectionListener {

	private Combo selectDriver;
	private Text username;
	private Text password;
	private Composite container;
	private Combo storeType;

	public LargeLogSupportUI() {
		super();
		
	}
	public Control createControl(Composite parent) {
				
		container = new Composite(parent,SWT.NONE);
		container.setLayoutData(GridDataUtil.createFill());
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 2;
		container.setLayout(layout);
		
		Label lDBType = new Label(container, SWT.NONE);
		lDBType.setText(LogUIPlugin.getResourceString("LLSP_STORE_TYPE"));
		
		storeType = new Combo(container,SWT.BORDER | SWT.READ_ONLY);
		storeType.setLayoutData(GridDataUtil.createHorizontalFill());
		
		initPossibleDBType();
		
		Label lUsername = new Label(container, SWT.NONE);
		lUsername .setText(LogUIPlugin.getResourceString("LLSP_DB_USERNAME"));
		
		username = new Text(container,SWT.BORDER);
		username.setLayoutData(GridDataUtil.createHorizontalFill());
		
		Label lPassword = new Label(container, SWT.NONE);
		lPassword.setText(LogUIPlugin.getResourceString("LLSP_DB_PASSWORD"));

		password = new Text(container,SWT.BORDER);
		password.setEchoChar('*');
		password.setLayoutData(GridDataUtil.createHorizontalFill());
		
		
		initializeValues(false);
//		WorkbenchHelp.setHelp(username, ContextIds.ACTLOG_VIEW_DIALOG_FILTER_ERROR);
//		WorkbenchHelp.setHelp(password, ContextIds.ACTLOG_VIEW_DIALOG_FILTER_WARNING);

		return container;
	}

	private void initPossibleDBType() {
		String defaultDBType = LogUIPlugin.getDefault().getPreferenceStore().getString(IHyadesResourceFactory.LARGE_LOG_SUPPORT_DB_TYPE);
		int index=-1;
		int i=0;
		for(Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();iter.hasNext();)
		{
			Map.Entry entry = (Map.Entry)iter.next();
			String postfix = (String)entry.getKey();
			IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)entry.getValue();
			if(hyadesResourceFactory != null && hyadesResourceFactory.isEnabledFor(postfix))
			{
				storeType.add(hyadesResourceFactory.getStoreType(postfix));
				if(hyadesResourceFactory.getStoreType(postfix).equals(defaultDBType))
					index=i;
				i++;
			}
		}
		if(index!=-1)
			storeType.select(index);
		
	}
	public void initializeValues(boolean defaultValue) {
				
		Preferences store = HierarchyPlugin.getPlugin().getPluginPreferences();
		
		String s = defaultValue ? store.getDefaultString(IHyadesResourceFactory.LLSP_USERNAME):store.getString(IHyadesResourceFactory.LLSP_USERNAME);
		if(s!=null)
			username.setText(s);
		s = defaultValue ? store.getDefaultString(IHyadesResourceFactory.LLSP_PASSWORD):store.getString(IHyadesResourceFactory.LLSP_PASSWORD);
		if(s!=null)
			password.setText(s);
		s = defaultValue ? store.getDefaultString(IHyadesResourceFactory.LARGE_LOG_SUPPORT_DB_TYPE):store.getString(IHyadesResourceFactory.LARGE_LOG_SUPPORT_DB_TYPE);
		if(s!=null)
			storeType.setText(s);
		
	}
	
	public boolean storeValues() {
		Preferences newStore = HierarchyPlugin.getPlugin().getPluginPreferences();
		newStore.setValue(IHyadesResourceFactory.LARGE_LOG_SUPPORT_DB_TYPE, storeType.getText());
		newStore.setValue(IHyadesResourceFactory.LLSP_USERNAME, username.getText());
		newStore.setValue(IHyadesResourceFactory.LLSP_PASSWORD, password.getText());
		return true;
	}

	/**
	 * @return Composite
	 */
	public Composite getControl() {
		return container;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {

	}

}