/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.runner.internal.exec;

import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.hyades.test.http.runner.HttpHeader;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.http.runner.HttpResponse;

/**
 * @author morris
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HttpRequestHandler {
	
	// quoted strings in this source file are directly associated with HTTP Protocol
	// and must not be localized
	static final String HTTP_LINE_TERMINATOR = "\r\n";
	static final String HTTP_HEADERS_END = "\r\n\r\n";
	static final String HTTP_CONTENT_TYPE = "CONTENT-TYPE: ";
	static final String HTTP_CONTENT_LENGTH = "CONTENT-LENGTH: ";
	static final String HTTP_SET_COOKIE = "SET-COOKIE: ";
	static final String HTTP_TRANSFER_ENCODING = "TRANSFER-ENCODING: ";
	static final String HTTP_CONNECTION = "CONNECTION: ";
	static final String HTTP_CLOSE = "CLOSE";
	static final String HTTP_CHUNKED = "CHUNKED";
	static final String HTTP_HTTP = "HTTP";

	private byte[] buffer = null;
	private int bufferSize = 0;
	
	
	public HttpRequestHandler(){
		int i = 0;
	}
	
	public boolean sendRequest(HttpRequest request, OutputStream outputStream){
		try {
			HttpHeader[] headers = request.getHeaders();
			StringBuffer strBuf = new StringBuffer();
			strBuf.append(request.getMethod());
			strBuf.append(" ");
			strBuf.append(request.getAbsolutePath());
			strBuf.append(" HTTP/");
			strBuf.append(request.getVersion());
			strBuf.append(HTTP_LINE_TERMINATOR);

			for(int i = 0, maxi = headers.length; i < maxi; i++){
				String str = headers[i].toString();
				strBuf.append(str);
				strBuf.append(HTTP_LINE_TERMINATOR);
			}

			// add a blank line to terminate the server request
			strBuf.append(HTTP_LINE_TERMINATOR);
			outputStream.write(strBuf.toString().getBytes());
			// this would be POST data
			if(request.getBody() != null)
			{				
				outputStream.write(request.getBody().getBytes());
			}
			outputStream.flush();
		}
		catch (Exception e){
			return false;
		}
		return true;
	}

	public boolean getServerResponse(HttpRequest request, HttpResponse response, InputStream inputStream, int bufSize){
		// if the server headers include Connection: Close, then set this flag to loop until we 
		// throw a closed socket exception
		boolean bWaitForClose = false;
		
		
		try {
			int bytes_read;
			int iContentLength = 0, iResponseCode = 0, iContentSoFar = 0, iContentBegin = 0;
			int iChunkLength = -1, iThisChunkStart = 0, iTotalLength = 0;
			boolean bNeedHeaders = true;
			boolean bChunked = false;
			StringBuffer stringBuffer = null;

			if (buffer == null || bufferSize != bufSize){
				 buffer = new byte[bufSize];
				 bufferSize = bufSize;
			}
			
			// next, we do however many reads it takes and make a determination
			// as to when the server response is completed 	
			while ((bytes_read = inputStream.read(buffer)) != -1){
				if (bNeedHeaders == true){
					String str = new String(buffer, 0, bytes_read);
					str = str.toUpperCase();
					String strRet = null;
					int iEndOfHeaders = str.indexOf(HTTP_HEADERS_END) + HTTP_HEADERS_END.length() - 1;
					bNeedHeaders = false;
					iContentBegin = iEndOfHeaders + 1;
					// the following if statement covers the case where there are no real headers
					// instead, there is HTML code indicating a 302 or whatever
					if (iEndOfHeaders > HTTP_HTTP.length()){
				
						getCookieHeaders(response, str, iEndOfHeaders);
						
						strRet = getHeaderString(str, HTTP_CONTENT_LENGTH, iEndOfHeaders);
						if (strRet != null){
							iContentLength = Integer.parseInt(strRet);
						}
						response.setContentLength(iContentLength);
							
						iResponseCode = getServerResponseCode(str);		
						response.setCode(iResponseCode);

						strRet = getHeaderString(str, HTTP_CONTENT_TYPE, iEndOfHeaders);
						response.setContentType(strRet);
						
						
						strRet = getHeaderString(str, HTTP_CONNECTION, iEndOfHeaders);
						if (strRet != null){
							strRet = strRet.toUpperCase();
							if (strRet != null && strRet.indexOf(HTTP_CLOSE) >= 0){
								bWaitForClose = true;
								response.setShouldCloseSocket(true);
							}
						}
						strRet = getHeaderString(str, HTTP_TRANSFER_ENCODING, iEndOfHeaders);
						if (strRet != null && strRet.indexOf(HTTP_CHUNKED) >= 0){
							bChunked = true;
							stringBuffer = new StringBuffer();
						}
					}
					if (bytes_read > iEndOfHeaders + 1)
						iContentSoFar = bytes_read - iEndOfHeaders - 1;
					
					
				}
				else {
					iContentBegin = 0;
					iContentSoFar += bytes_read;
					String str = new String(buffer, 0, bytes_read);
					
				}
				if (bChunked && iContentSoFar > 0){
					String str = new String(buffer, iContentBegin, bytes_read - iContentBegin);
					stringBuffer.append(str);
					iTotalLength = stringBuffer.length();
					
					// see if we need to read the chunk length
					if (iChunkLength == -1 || ((iTotalLength - iThisChunkStart) > iChunkLength)){
						int iTokenIndex;
						// advance ithisto next chunk or first chunk
						if (iChunkLength == -1)
							iChunkLength = 0;
						while (iTotalLength - iThisChunkStart > iChunkLength){
							iThisChunkStart += iChunkLength;
							iTokenIndex = stringBuffer.toString().indexOf(HTTP_LINE_TERMINATOR, iThisChunkStart);
							if (iTokenIndex >= 0){
								int i = 1, iParsePos = iTokenIndex;
								char chZero = '0';
								// look for any white space characters before the line terminator string
								while ((iThisChunkStart + i ) < iTokenIndex){
									if (stringBuffer.charAt(iThisChunkStart + i) < chZero){
										iParsePos = iThisChunkStart + i;
										break;
									}
									i++;
								};
								String strTemp = stringBuffer.substring(iThisChunkStart, iParsePos);
								iChunkLength = Integer.parseInt(stringBuffer.substring(iThisChunkStart, iParsePos), 16);
								if (iChunkLength > 0)
									iChunkLength += HTTP_LINE_TERMINATOR.length();
								iThisChunkStart = iTokenIndex + HTTP_LINE_TERMINATOR.length();
								// if a zero chunk length is reached, we are done
								if (iChunkLength == 0)
									break;
							}
						}
					}
				}
				if (bChunked && iChunkLength == 0){
					break;
				}
				if (!bChunked  && iContentSoFar >= iContentLength  && !bWaitForClose){
					break;  // server response is done
				}
				if (iResponseCode > 300 && iContentLength == 0){
					break;  // redirect or error, no further response from server expected.
				}
				if (iChunkLength == -1)
					iChunkLength = 0;
			}
		}
		catch (Exception e){
			if (!bWaitForClose){
				System.out.println(e);
				response.setCode(-1);
				response.setDetail(e.getLocalizedMessage());
				return false;
			}
		}
		
		return true;
	}

	private void getCookieHeaders(HttpResponse response, String str, int iEndOfHeaders){
		int iSubStart = 0, iSubEnd, index;
		String strCookie = null;
		do{
			index = str.indexOf(HTTP_SET_COOKIE, iSubStart);
			if (index >= 0 && index < iEndOfHeaders ){
				index += HTTP_SET_COOKIE.length();
				iSubEnd = str.indexOf(HTTP_LINE_TERMINATOR, index);
				strCookie = str.substring(index, iSubEnd);
				HttpHeader header = new HttpHeader();
				// do not localize this string
				header.setName("Set-Cookie");
				header.setValue(strCookie);
				response.addHeader(header);
				iSubStart = iSubEnd + 1;
			}
		}while (index >= 0);
		return;
		
	}
		
	private String getHeaderString(String str, String strName, int iEndOfHeaders){
		String strRet = null;
		int iSubStart, iSubEnd;
		str = str.toUpperCase();
		iSubStart = str.indexOf(strName);
		if (iSubStart >= 0 && iSubStart < iEndOfHeaders ){
			iSubStart += strName.length();
			iSubEnd = str.indexOf(HTTP_LINE_TERMINATOR, iSubStart);
			strRet = str.substring(iSubStart, iSubEnd);
		}
		return strRet;
	}
	private int getServerResponseCode(String str){
		int iCode = 0;
		int iSubStart, iSubEnd, iSubWhat;
		
		// confirm that the HTTP line is at the beginning of the headers
		iSubWhat = str.indexOf("HTTP");		
		if (iSubWhat >= 0 && iSubWhat <= 2 ){
			// find first blank after that
			if ((iSubStart = str.indexOf(" ", iSubWhat)) >= 0){
				// now grab the server response code
				iSubStart++;
				iSubEnd = iSubStart + 3;
				String strTemp = str.substring(iSubStart, iSubEnd);
				iCode = Integer.parseInt(strTemp);
			}
		}
		else{
			iCode = -1;
		}
		return iCode;
	}
}
