/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.util;
 
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URL;

import javax.swing.AbstractButton;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import org.eclipse.hyades.test.common.util.BaseString;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class SwingUtil
{
	public static Container addLabelComponentRows(Container container, GridBagLayout gridbag, JLabel[] labels, JComponent[] components)
	{
		container.setLayout(gridbag);
		
		GridBagConstraints c = new GridBagConstraints();
		c.anchor = GridBagConstraints.NORTHWEST;
		
		int top = 2;
		int botton = 2;
		for (int i=0, numLabels=labels.length; i < numLabels; i++)
		{
			if((labels[i] == null) || (components[i] == null))
				continue;
				
			top = (i==0?0:2);
			botton = (i==(numLabels-1)?0:2);
			c.insets = new Insets(top, 2, botton, 2);
			
			if(labels[i].getLabelFor() == null)
				labels[i].setLabelFor(components[i]);
			adjustMnemonic(labels[i]);
			
			c.gridwidth = GridBagConstraints.RELATIVE;		//next-to-last
			c.fill = GridBagConstraints.NONE;				//reset to default
			c.weightx = 0.0;								//reset to default
			gridbag.setConstraints(labels[i], c);
			container.add(labels[i]);

			c.gridwidth = GridBagConstraints.REMAINDER;     //end row
			c.fill = GridBagConstraints.HORIZONTAL;
			c.weightx = 1.0;
			gridbag.setConstraints(components[i], c);
			container.add(components[i]);
		}
		
		return container;
	}
	
	public static void adjustMnemonic(JLabel label)
	{
		if((label == null) || (label.getDisplayedMnemonic() > 0))
			return;
		
		String text  = label.getText();
		int length = text.length();
		int index=0;
		while(index >= 0)
		{
			index = text.indexOf("&", index);
			if(index < (length-1))
			{
				char ret = text.charAt(++index);
				if(ret == '&')
					continue;
					
				text = text.substring(0, index-1) + text.substring(index);
				label.setText(text);
				label.setDisplayedMnemonic(ret);
				index = -1;
			}			
		}		
	}
	
	public static void adjustMnemonic(AbstractButton abstractButton)
	{
		if((abstractButton == null) || (abstractButton.getMnemonic() > 0))
			return;
		
		String text  = abstractButton.getText();
		int length = text.length();
		int index=0;
		while(index >= 0)
		{
			index = text.indexOf("&", index);
			if((index >= 0) && (index < (length-1)))
			{
				char ret = text.charAt(++index);
				if(ret == '&')
					continue;
					
				text = text.substring(0, index-1) + text.substring(index);
				abstractButton.setText(text);
				abstractButton.setMnemonic(ret);
				index = -1;
			}			
		}		
	}




	/**
	 * Expands all nodes in a JTree.
	 *
	 * @param tree      The JTree to expand.
	 * @param depth     The depth to which the tree should be expanded.  Zero
	 *                  will just expand the root node, a negative value will
	 *                  fully expand the tree, and a positive value will
	 *                  recursively expand the tree to that depth.
	 */
	public static void expandTree(JTree tree, int depth, boolean expand)
	{
		if(tree == null)
			return;
			
		expandTree(tree, tree.getModel().getRoot(), 0, depth, expand);
	} 
	
	/**
	 * Expands a given node in a JTree.
	 *
	 * @param tree      The JTree to expand.
	 * @param node      The node within tree to expand.     
	 * @param row       The displayed row in tree that represents
	 *                  node.     
	 * @param depth     The depth to which the tree should be expanded. 
	 *                  Zero will just expand node, a negative
	 *                  value will fully expand the tree, and a positive
	 *                  value will recursively expand the tree to that
	 *                  depth relative to node.
	 */
	public static int expandTree(JTree tree, Object node, int row, int depth, boolean expand)
	{
		if((tree == null) || (tree.getModel() == null))
			return -1;
			
		TreeModel model = tree.getModel();
		if(node != null && !model.isLeaf(node))
		{
			if(expand)
				tree.expandRow(row);
			else
				tree.collapseRow(row);
				
			if(depth != 0)
			{
				for(int index = 0; row + 1 < tree.getRowCount() && index < model.getChildCount(node); index++)
				{
					row++;
					Object child = model.getChild(node, index);
					if(child == null)
						break;
						
					TreePath path = null;
					while((path = tree.getPathForRow(row)) != null && path.getLastPathComponent() != child)
						row++;
						
					if(path == null)
						break;
						
					row = expandTree(tree, child, row, depth - 1, expand);
				}
			}
		}
		return row;
	}
	
	public static Dimension getMaxWidth(Dimension d1, Dimension d2)
	{
		if(d1 == null)
			return d2;
		if(d2 == null)
			return d1;
		
		if(d1.getWidth() > d2.getWidth())
			return d1;
			
		return d2;
	}
	
	public static Dimension resizeDimension(Dimension d, double widthFactor, double heightFactor)
	{
		if(d == null)
			return null;
		if((widthFactor == 1) && (heightFactor == 1))
			return d;
			
		return new Dimension((int)(d.getWidth()*widthFactor), (int)(d.getHeight()*heightFactor));
	}
	
	public static void setSameSize(JComponent[] components)
	{
		setSameSize(components, 1, 1);
	}
	
	public static void setSameSize(JComponent[] components, double factor)
	{
		setSameSize(components, factor, factor);
	}
	
	public static void setSameSize(JComponent[] components, double widthFactor, double heightFactor)
	{
		Dimension maxMinSize = null;
		for(int i=0, length=components.length; i<length; i++)
			maxMinSize = getMaxWidth(maxMinSize, components[i].getMinimumSize());
		
		maxMinSize = resizeDimension(maxMinSize,widthFactor, heightFactor);
		
		for(int i=0, length=components.length; i<length; i++)
		{
			components[i].setMinimumSize(maxMinSize);
			components[i].setPreferredSize(maxMinSize);
			components[i].setMaximumSize(maxMinSize);
		}
	}
	
	public static boolean selectComboItemByValue(JComboBox combo, String value)
	{
		for(int i=0, size=combo.getItemCount(); i<size; i++)
			if(((String)combo.getItemAt(i)).equals(BaseString.toString(value)))
			{
				combo.setSelectedIndex(i);
				return true;
			}
			
		return false;
	}
		
	public static final int NORMAL = 0;
	public static final int RUNNING = 1;
	public static final int COMPLETED = 2;
	public static final int DISABLED = 3;
	
	public static Icon getIcon(String imageName)
	{
		if(imageName == null)
			return null;
			
		URL iconURL = ClassLoader.getSystemResource("icons/" + imageName);
		if(iconURL == null)
			return null;
		
		return new ImageIcon(iconURL);
	}
	
	public static Icon getIcon(String imageName, int type, boolean enabled)
	{
		Icon icon = getIcon(imageName);
		if(icon == null)
			return null;
			
		if(!enabled)
		{
			Image image = null;
			if(icon instanceof ImageIcon)
				image = ((ImageIcon)icon).getImage();
			
			if(image != null)
            	icon = new ImageIcon(GrayFilter.createDisabledImage(image));
		}	

		if(type != NORMAL)
		{
			OverlayIcon overlayIcon = new OverlayIcon(icon);
			switch(type)
			{
				case RUNNING:
					overlayIcon.setRightTopIcon(getIcon("run_ovr.gif"));
					break;
					
				case COMPLETED:
					overlayIcon.setRightTopIcon(getIcon("complete_ovr.gif"));
					break;
			}
			icon = overlayIcon;
		}
				
		return icon;
	}
}
