package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.ComplexType;


/**
* This class represents the complex type <AgentControllerEnvironment>
*/
public class AgentControllerEnvironment extends ComplexType
{
  public AgentControllerEnvironment()
  {
  }
  
  public void setVariable(int index, Variable Variable)
  {
    setElementValue(index, "Variable", Variable);
  }
  
  public Variable getVariable(int index)
  {
    return (Variable) getElementValue("Variable", "Variable", index);
  }
  
  public int getVariableCount()
  {
    return sizeOfElement("Variable");
  }
  
  public boolean removeVariable(int index)
  {
    return removeElement(index, "Variable");
  }
  
  public void setConfiguration(String configuration)
  {
    setAttributeValue("configuration", configuration);
  }
  
  public String getConfiguration()
  {
    return getAttributeValue("configuration");
  }
  
  public boolean removeConfiguration()
  {
    return removeAttribute("configuration");
  }
  
}

