package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.ComplexType;

/**
* This class represents the complex type <Security>
*/
public class Security extends ComplexType
{
	public Security()
	{
	}
  
	public void setUserDefinition(int index, UserDefinition UserDefinition)
	{
		setElementValue(index, "UserDefinition", UserDefinition);
	}
  
	public UserDefinition getUserDefinition(int index)
	{
		return (UserDefinition) getElementValue("UserDefinition", "UserDefinition", index);
	}
  
	public int getUserDefinitionCount()
	{
		return sizeOfElement("UserDefinition");
	}
  
	public boolean removeUserDefinition(int index)
	{
		return removeElement(index, "UserDefinition");
	}
  
	public void setGroupDefinition(int index, GroupDefinition GroupDefinition)
	{
		setElementValue(index, "GroupDefinition", GroupDefinition);
	}
  
	public GroupDefinition getGroupDefinition(int index)
	{
		return (GroupDefinition) getElementValue("GroupDefinition", "GroupDefinition", index);
	}
  
	public int getGroupDefinitionCount()
	{
		return sizeOfElement("GroupDefinition");
	}
  
	public boolean removeGroupDefinition(int index)
	{
		return removeElement(index, "GroupDefinition");
	}
  
	public void setConfiguration(String configuration)
	{
		setAttributeValue("configuration", configuration);
	}
  
	public String getConfiguration()
	{
		return getAttributeValue("configuration");
	}
  
	public boolean removeConfiguration()
	{
		return removeAttribute("configuration");
	}
  
	public void setLibrary(String library)
	{
		setAttributeValue("library", library);
	}
  
	public String getLibrary()
	{
		return getAttributeValue("library");
	}
  
	public boolean removeLibrary()
	{
		return removeAttribute("library");
	}

	public void setProvider(String provider) {
		setAttributeValue("provider", provider);
	}

	public String getProvider() {
		return getAttributeValue("provider");
	}

	public boolean removeProvider() {
		return removeAttribute("provider");
	}

	public void setKeystoreManager(String keyManager) {
		setAttributeValue("keystoreManager", keyManager);
	}

	public String getKeystoreManager() {
		return getAttributeValue("keystoreManager");
	}

	public boolean removeKeystoreManager() {
		return removeAttribute("keystoreManager");
	}

	public void setCipherSuites(String cipherSuites) {
		setAttributeValue("cipherSuites", cipherSuites);
	}

	public String getCipherSuites() {
		return getAttributeValue("cipherSuites");
	}

	public boolean removeCipherSuites() {
		return removeAttribute("cipherSuites");
	}

	public void setProtocols(String protocols) {
		setAttributeValue("protocols", protocols);
	}

	public String getProtocols() {
		return getAttributeValue("protocols");
	}

	public boolean removeProtocols() {
		return removeAttribute("protocols");
	}

	public void setClientAuthenticate(String clientAuthenticate)
	{
		setAttributeValue("clientAuthenticate", clientAuthenticate);
	}
  
	public String getClientAuthenticate()
	{
		return getAttributeValue("clientAuthenticate");
	}
  
	public boolean removeClientAuthenticate()
	{
		return removeAttribute("clientAuthenticate");
	}
  
	public void setAclEnabled(String aclEnabled)
	{
		setAttributeValue("aclEnabled", aclEnabled);
	}
  
	public String getAclEnabled()
	{
		return getAttributeValue("aclEnabled");
	}
  
	public boolean removeAclEnabled()
	{
		return removeAttribute("aclEnabled");
	}
  
	public void setKeystore(String keystore)
	{
		setAttributeValue("keystore", keystore);
	}
  
	public String getKeystore()
	{
		return getAttributeValue("keystore");
	}
  
	public boolean removeKeystore()
	{
		return removeAttribute("keystore");
	}
  
	public void setKeystorePassword(String keystorePassword)
	{
		setAttributeValue("keystorePassword", keystorePassword);
	}
  
	public String getKeystorePassword()
	{
		return getAttributeValue("keystorePassword");
	}
  
	public boolean removeKeystorePassword()
	{
		return removeAttribute("keystorePassword");
	}

	public void setServerAlias(String serverAlias)
	{
		setAttributeValue("serverAlias", serverAlias);
	}
  
	public String getServerAlias()
	{
		return getAttributeValue("serverAlias");
	}
  
	public boolean removeServerAlias()
	{
		return removeAttribute("serverAlias");
	}

}
