/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.statistical;

import java.util.Map;

import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.impl.SDCounterDescriptorImpl;
import org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl;
import org.eclipse.hyades.model.statistical.impl.SDSampleDescriptorImpl;
/**
 * @author slavescu
 */
public class StatisticalLookupService extends GenericLookupService {
	//~ Constructors
	// -------------------------------------------------------------------------------

	public StatisticalLookupService() {
		super();
		types.add(SDDescriptorImpl.class);
		types.add(SDSampleDescriptorImpl.class);
		types.add(SDCounterDescriptorImpl.class);
	}

	//~ Methods
	// ------------------------------------------------------------------------------------

	protected boolean doProcessObject(
		Map typeMap,
		Class type,
		Object object,
		boolean remove) {
		if (object == null) {
			return false;
		}
		if(object instanceof SDDescriptor)
		{	
				addOrRemove(
					typeMap,
					((SDDescriptor) object).getId(),
					object,
					remove);

				return true;
		}
		
		return false;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.GenericLookupService#useAssignableFrom(java.lang.Class)
	 */
	protected boolean useAssignableFrom(Class type) {
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.GenericLookupService#getTypeMap(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.Class, boolean)
	 */
	protected Map getTypeMap(HierarchyContext context, Class type, boolean create) {
		return super.getTypeMap(context, SDDescriptor.class, create);
	}
}
