/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.config.sensors;
import java.util.Hashtable;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
/**
 * A sensor that calls a static parser that generates CBEs
 * 
 * @version 0.1
 */
public class StaticParserSensor extends Sensor
{
	public final static String PATH_SEPARATOR = System.getProperty("file.separator");
	
	/** 
	 * class name for the static parser
	 */
	protected String parserClassName = null;


	/** 
	 * instance of static parser class
	 */
	protected Parser parser = null;
		
	/**
	 * directory address to start with, maybe relative or absolute 
	 */
	private String directory = null;
	
		
	/**
	 * relative file name (just name), maybe just regular expression 
	 */
	private String fileName = null;
	protected String rawLogFileName = null;

	/**
	 * Array of CommonBaseEvent objects that were parsed from the data in a file. 
	 * 
	 */
	private ICommonBaseEvent[] messages = null;
    
	/**
	 * Constructor for SingleOSFileSensor.
	 */
	public StaticParserSensor()
	{
		super();
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#stop()
	 */
	public void stop()
	{
		super.stop();
		clean();
	}

	/**
	 * update the configuration based on the configuration Element
	 */
	public void update() throws AdapterInvalidConfig
	{
		// first get the basic configuration set
		super.update();
		// maximumBlocking is set by the sensor config
		String directory = null;
		String fileName = null;
		String className = null;

		String propertyName = null;
		String propertyValue = null;
		Element sensorInstance = null;
		Element sensorProperty = null;
		Element element = getConfiguration();
		// This sensor is configured with a sub element of the config
		NodeList sensorNodes = element.getChildNodes();
		for (int i = 0; i < sensorNodes.getLength(); i++)
			if (sensorNodes.item(i).getNodeType() == Node.ELEMENT_NODE)
				sensorInstance = (Element) sensorNodes.item(i);
		if (sensorInstance.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName")))
			directory = sensorInstance.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
		if (sensorInstance.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName")))
			fileName = sensorInstance.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
			
		if (sensorInstance.hasAttribute(Messages.getString("HyadesGAstaticParserClassAttributeName")))
			className = sensorInstance.getAttribute(Messages.getString("HyadesGAstaticParserClassAttributeName"));
			

		setDirectory(directory);
		setFileName(fileName);
		setParserClassName(className);
		
		// Construct the full input log file name
		if (getDirectory().endsWith(PATH_SEPARATOR)) {
			rawLogFileName = getDirectory() + getFileName();
		}
		else {
			rawLogFileName = getDirectory() + PATH_SEPARATOR + getFileName();
		}

		// Create the parameter Hashtable to be passed to the parser
		
		Hashtable parserParameters = new Hashtable();

		parserParameters.put(ParserConstants.FILE_PATH_KEY, rawLogFileName);
		parserParameters.put(ParserConstants.MESSAGE_ARRAY_SIZE_KEY, new Integer(maximumBlocking));
		
		sensorNodes = sensorInstance.getChildNodes();
		for (int i = 0; i < sensorNodes.getLength(); i++) {
			if (sensorNodes.item(i).getNodeType() == Node.ELEMENT_NODE) {
				sensorProperty = (Element) sensorNodes.item(i);
				// get name and value from property and add the property to the hash table.
				if (sensorProperty.hasAttribute(Messages.getString("HyadesGASensorPropertyNameTag")))
					propertyName = sensorProperty.getAttribute(Messages.getString("HyadesGASensorPropertyNameTag"));

				if (sensorProperty.hasAttribute(Messages.getString("HyadesGASensorPropertyValueTag")))
					propertyValue = sensorProperty.getAttribute(Messages.getString("HyadesGASensorPropertyValueTag"));
					
				if (propertyName != null && 
					propertyName.length() > 0 &&
					propertyValue != null &&
					propertyValue.length() > 0) {
					parserParameters.put(propertyName, propertyValue);
				}
			}
		}

		parser=(Parser)getParser(getParserClassName());
		if(parser!=null) {
			
			try {
				parser.setConfiguration(parserParameters);
				parser.preParse();
			}
			catch(Throwable e) {
				
			}
		}
		
	}
	/**
	 * 	simulates a getNext
	 * @see com.ibm.acad.general.sensor.ISensor#testGetNext()
	 */
	public Object[] testGetNext()
	{
		ICommonBaseEvent[] eventArray = new ICommonBaseEvent[1];
		eventArray[0] = SimpleEventFactoryImpl.getInstance().createCommonBaseEvent();
		return eventArray;
	}

	/**
	 * 	returns last read line
	* @see com.ibm.acad.general.sensor.ISensor#getNext()
	 */
	public Object[] getNext()
	{
/*		if (messages != null) {
			return null;
		}
*/		
		if (parser == null) {
			return null;	
		}
		
		messages = null;
		
		try {
			
			messages=parser.parseNext();

		}
		catch (Throwable t) {
			// TODO Handle this exception
			log(Messages.getString("HyadesGA_CBE_File_Parsing_Error",rawLogFileName ,t.toString()), AdapterSensor.FATAL_LEVEL);
		}
		

		if (messages != null && messages[0] != null) {
			return messages;
		}
		else {
			return null;
		}
	}
	/**
	 * do all cleaning here
	 */
	public void clean()
	{
		try
		{

		}
		catch (Exception e)
		{
			log(e.toString(), AdapterSensor.HARMLESS_LEVEL);
		}
	}

	/**
	 * Returns the directory.
	 * @return String
	 */
	final public String getDirectory()
	{
		return directory;
	}
	/**
	 * Returns the fileName.
	 * @return String
	 */
	final public String getFileName()
	{
		return fileName;
	}
	/**
	 * Sets the directory.
	 * @param directory The directory to set
	 */
	final public void setDirectory(String directory)
	{
		this.directory = directory;
	}
	/**
	 * Sets the fileName.
	 * @param fileName The fileName to set
	 */
	final public void setFileName(String fileName)
	{
		this.fileName = fileName;
	}
	/**
	 * @return
	 */
	public String getParserClassName() {
		return parserClassName;
	}


	/**
	 * @param string
	 */
	public void setParserClassName(String string) {
		parserClassName = string;
	}
	
	public IParser getParser(String classname) {
		IParser parser=null;
		
		try {
			// Create a parser instance
			parser = (IParser)Class.forName(getParserClassName()).newInstance();
		}
		catch (Throwable t) {
			// Get parser instance using plugin registry
			IConfigurationElement[] elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.adapter.config", "staticParser");
			for(int i=0; i<elements.length; i++) {
				IConfigurationElement elem = elements[i];
				if(elem.getAttribute("name").equals(classname)) {
					try {
						parser=(IParser)elem.createExecutableExtension("name");
						break;
					}
					catch(Throwable e) {	

						e.printStackTrace();			
						/* If we can't instantiate it then ignore it */
					}	
				}
			}
		}
		return parser;
	}

}
