/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.analysis.engine;

import org.eclipse.core.runtime.*;
/**
 *	This interface is required to be implemented by pluggable log analyzers
 */
public interface ILogAnalyzer {

	/**
	 * Analyzes an object or a collection of objects.
	 * @param aObject the object to be analyzed.
	 * @return the result of the analysis process. 
	 */	
	public String analyze(Object aObject);
	
	/**
	 * Returns an error message if the analyze process fails for some reason.
	 */		
	public String errorMsg();
	
	/**
 	* 
 	* @author znensi
 	*
 	*	import the database into the workspace
 	*	used when the user specifies a symptom database file that is not
 	*	within the workspace
 	*/
	public void importDB(IProgressMonitor monitor);
	
	
	/**
	 * Loads the symptom databases used for log analysis.	 
	 */
	public void loadDatabase();
	
	/**
	 * Unloads the symptom databases used for log analysis.	 
	 */
	public void unloadDatabase();
	
}
