/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import java.util.*;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PDLabelProvider extends LabelProvider
{
  private Map imageTable;
  
  private Image fMonitor =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_MONITOR);
  private Image fNode =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_NODE);
  private Image fProcess =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_PROCESS);

  private Image fMonAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_MON_AGENT);
  private Image fRunAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_RUN_AGENT);
  private Image fStopAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_STOP_AGENT);

  private Image fDetachedAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_DETACHED_AGENT);  
	
/**
 * Disposes of all IWorkbenchAdapter based allocated images.
 */
public void dispose() {
	if (imageTable != null) {
		for (Iterator i = imageTable.values().iterator(); i.hasNext();) {
			((Image) i.next()).dispose();
		}
		imageTable = null;
	}
}

/**
 * Returns the image to display for the passed resource element.
 * NOTE: The resource label provider caches its images, so don't
 * dispose them!
 */
public Image getImage(Object element)
{
	if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		if(adapter != null)
		{
			//obtain the cached image corresponding to the descriptor
			if (imageTable == null) {
				 imageTable = new Hashtable(40);
			}
			ImageDescriptor descriptor = adapter.getImageDescriptor(element);		
			Image image = (Image) imageTable.get(descriptor);
			if (image == null) {
				image = descriptor.createImage();
				imageTable.put(descriptor, image);
			}
			return image;
		}
		else
		{
			return null;
		}

	}
	else if(element instanceof TRCMonitor)
	  return fMonitor;
	else if(element instanceof TRCNode)
	  return fNode;
	else if(element instanceof TRCProcessProxy)
	  return fProcess;
	else if(element instanceof TRCAgentProxy)
	{
	  if(!((TRCAgentProxy)element).isActive())	  
		    return fStopAgent; //inactive
	  if(!((TRCAgentProxy)element).isAttached())
		    return fDetachedAgent; //detached		    
	  if(((TRCAgentProxy)element).isMonitored())
		    return fMonAgent; //monitored

	  return fRunAgent; //running and attached	    
		
	}

	return null;
}
/* (non-Javadoc)
 * Method declared on ILabelProvider.
 */
public String getText(Object element)
{
	if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter == null ? "?" : adapter.getLabel(element);
	}
	else if(element instanceof TRCMonitor)
	  return ((TRCMonitor)element).getName();
	else if(element instanceof TRCNode)
	  return ((TRCNode)element).getName();//+":"+String.valueOf(((TRCNode)element).getPort());
	else if(element instanceof TRCProcessProxy)
	  return HyadesUtil.getProcessName((TRCProcessProxy)element);
	else if(element instanceof TRCAgentProxy)
	{
	  TRCAgentProxy a = (TRCAgentProxy)element;	  
	  String status = HyadesUtil.getAgentLabel(a);
	  
	  return status+" "+HyadesUtil.getAgentName(a);
	}
	  
	return "?";
}
}
