/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.part.Page;
		
/**
 * A message page display a message in a pagebook view.
 * <p>
 * This class may be instantiated; it is not intended to be subclassed.
 * </p>
 *
 * @see PageBookView
 */
public class DefaultPage extends Page {
	private Composite pgComp;
	private Text msgLabel;
	private String message = "";//$NON-NLS-1$
/**
 * Creates a new page. The message is the empty string.
 */
public DefaultPage() {
}
/* (non-Javadoc)
 * Method declared on IPage.
 */
public void createControl(Composite parent) {
	// Message in default page of Outline should have margins
	pgComp = new Composite(parent, SWT.NULL);
	pgComp.setLayoutData(GridUtil.createFill());
	pgComp.setLayout(new GridLayout());
	
	msgLabel = new Text(pgComp, SWT.MULTI | SWT.READ_ONLY |SWT.WRAP);
	msgLabel.setLayoutData(GridUtil.createFill());
	msgLabel.setText(message);
}
/* (non-Javadoc)
 * Method declared on IPage.
 */
public Control getControl() {
	return pgComp;
}
/**
 * Sets focus to a part in the page.
 */
public void setFocus() {
	msgLabel.setFocus();
}
/**
 * Sets the message to the given string.
 *
 * @param message the message text
 */
public void setMessage(String message) {
	this.message = message;
	if (msgLabel != null)
		msgLabel.setText(message);
}
}
