/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

import java.util.*;
import java.text.*;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.security.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * This class provides static methods for some of the
 * very used IString operations
 */

public class HyadesUtil
{
	/**
	 * Test the RAC connection on a host with given port number
	 */
	public static final int CONNECTION_SUCCESS = 0;
	public static final int CONNECTION_CONTROLLER_ERROR = 1;
	public static final int CONNECTION_HOST_ERROR = 2;
	public static final int CONNECTION_PORT_ERROR = 3;
	
  private static StringBuffer tmpBuffer = new StringBuffer();

   // change all occurrences of oldPat to newPat
   public  static String change(String in, String oldPat, String newPat)
   {
	  if (oldPat.length() == 0)
		 return in;
	  if (oldPat.length() == 1 && newPat.length() == 1)
		 return in.replace(oldPat.charAt(0), newPat.charAt(0));

	  int lastIndex = 0;
	  int newIndex = 0;
	  tmpBuffer.setLength(0);
	  
	  for(;;)
	  {
		 newIndex = in.indexOf(oldPat, lastIndex);
		 if (newIndex != -1)
		 {
			tmpBuffer.append(in.substring(lastIndex, newIndex)).append(newPat);
			lastIndex = newIndex + oldPat.length();
		 }
		 else
		 {
			tmpBuffer.append(in.substring(lastIndex));
			break;
		 }
	  }
	  return tmpBuffer.toString();
   }   
         /**
 * Insert the method's description here.
 * Creation date: (4/19/2001 4:59:39 PM)
 * @return java.lang.String
 * @param process com.ibm.etools.perftrace.TRCAgent
 */
public static String getAgentName(TRCAgentProxy agent)
{
	String type = agent.getType();
	String name = agent.getName();
	if(name == null)
	  name = "";
	  
	if(type.equals(HyadesConstants.PROFILE_AGENT_TYPE))
	{
		if(!name.equals(HyadesConstants.J2EE_AGENT_NAME))
			name = UIPlugin.getResourceString("TRACE_NAME");
	}
	else if(type.equals(HyadesConstants.LOG_AGENT_TYPE))
	{
			if(name.equals(""))
				name = UIPlugin.getResourceString("LOG_NAME");
	}
	 	
	if (agent.getStartTime() > 0)
	{
		Date date = new Date((long)agent.getStartTime() * 1000);
		String timestamp = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.MEDIUM).format(date);
		name += " (" + timestamp + ")";
	}
	
	return name;
}
/**
 * Insert the method's description here.
 * Creation date: (4/19/2001 4:59:39 PM)
 * @return java.lang.String
 * @param process com.ibm.etools.perftrace.TRCProcess
 */
public static String getProcessName(TRCProcessProxy process)
{
	tmpBuffer.setLength(0);
	
	return tmpBuffer.append(process.getName()).append(" [ PID:").append(process.getPid()).append(" ]").toString();

}
   public static String getAgentLabel(TRCAgentProxy a)
   {
   	  tmpBuffer.setLength(0);
   	  
	  if (a.isActive() && a.isMonitored()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_MONITORED"));	  	        
	  else if (a.isActive() && a.isAttached()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_ATTACHED"));
	  else if (a.isActive()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_DETACTED"));	  
	  else tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_TERMINATED"));
	  
	  if(a.isCollectionData())
	      tmpBuffer.append(UIPlugin.getResourceString("STR_COLLECTING")).append(">");
	  else
	      tmpBuffer.append(">");    
	  	  
	  return tmpBuffer.toString();   	  
   }  
          
   public static int testConnection(String host, String port,boolean message, Shell shell)
   {
	   if (host == null || host.trim() == "" || port == null || port.trim() == "")
	   {
		   String text = UIPlugin.getResourceString("INVALID_HOST");
		   Status err = new Status(Status.WARNING,ResourcesPlugin.PI_RESOURCES,IResourceStatus.WARNING,text,null);
		   ErrorDialog.openError(shell,UIPlugin.getResourceString("STR_TITLE_MSG")
		               ,UIPlugin.getResourceString("CONNECT_ERROR_"),err);
		
		   return CONNECTION_HOST_ERROR;
	   }
	
	   IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();	
	   ConnectUtil util = new ConnectUtil(host, port, store.getString(HyadesConstants.SECURE_USERID), UIPlugin.getDefault());
	   int result = util.connect();
	   if(result == ConnectUtil.CONNECTION_SUCCESS)
	   {//store the user id
		   store.setValue(HyadesConstants.SECURE_USERID, util.getUserId());
		
		   if(message)
		   {
			   String text = UIPlugin.getResourceString("CONNECTION_SUCCESS_TEXT");
			   MessageDialog.openInformation(shell,UIPlugin.getResourceString("STR_HYADES_MSG"),text);
		   }
		
	   }
	
	   return result;
   }
  
   public static IResource getSelectionFolder(Object selection)
   {
	   if(selection != null)
	   {
		   
		   if(selection instanceof IResource)
			  return (IResource)selection;
		   
		   if(selection instanceof EObject)
		   {
			   String strPath = TString.resourcePath(((EObject)selection).eResource().getURI());
			   return UIPlugin.getPluginWorkbench().getRoot().findMember((new Path(strPath)).removeLastSegments(1));
		   }   
	   }
	
	   return null;	
   }
  
  public static IResource getSelectionFolder(INavigator viewer){ 
		if(!viewer.getStructuredSelection().isEmpty())
  			return getSelectionFolder(viewer.getStructuredSelection().getFirstElement());
  		
  		return null;
  }
  
  public static void cleanupResources(String navigatorID){

	ProfileEvent event = new ProfileEvent();
	event.setSource(null);
	event.setType(ProfileEvent.CLEAN_UP);
	UIPlugin.getDefault().notifyProfileEventListener(event);

	IWorkbenchPage page = null;
	IWorkbenchWindow[] windows = UIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
	for (int i = 0; i < windows.length; i++) {
		IWorkbenchWindow window = windows[i];
		IWorkbenchPage[] pages = window.getPages();
		for (int j = 0; j < pages.length; j++) {
			page = pages[j];
			if(page!=null && page.getPerspective()!=null && page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE)){
				break;
			}
		}
	}
	
	if(page!= null){
		if(navigatorID.equals(PDPerspective.ID_PD_NAVIGATOR_VIEW)){
			IViewPart part = page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
			if(part!=null)
				return;	
		}else
		if(navigatorID.equals(PDPerspective.ID_LOG_NAVIGATOR_VIEW)){
			IViewPart part = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
		
			if(part!=null)
				return;
		}

	}

	try {
 			
		boolean modified = false;
		if (HierarchyResourceSetImpl.getInstance().getResources().size() > 0) {
				
			Iterator docs = HierarchyResourceSetImpl.getInstance().getResources().iterator();
			while(docs.hasNext())
			{
				org.eclipse.emf.ecore.resource.Resource res = (org.eclipse.emf.ecore.resource.Resource) docs.next();
				if(res != null && res.isLoaded() && res.isModified())
				{
					modified = true;
					break;
				}
			}
				
			if(modified)
			{
				String title = UIPlugin.getResourceString("TRACE_MSG");
	
				String msg = UIPlugin.getResourceString("SAVE_PROJECT_SQ");
	
				if (MessageDialog.openQuestion(null, title, msg)) {
					SaveUtil.saveDocuments();
	
					IResource res = UIPlugin.getPluginWorkbench().getRoot();
					res.refreshLocal(IResource.DEPTH_INFINITE, null);
				}
			}
				
//			//clear documents list
//			SaveUtil.getDocuments().clear();
			HierarchyResourceSetImpl.getInstance().getResources().clear();

		}
	} catch (Exception exc) {
		exc.printStackTrace();
		//do nothing
	}


	TraceUIManager.getTraceUIManager().dispose();
  
  }
  
  /**
   * 
   * @return selected trace or log object in the Profiling Monitors view or Log Navigator
   */
  public static EObject getMofObject()
  {
	  return getNavigatorSelection(getActiveNavigator());
  }
  
  public static INavigator getActiveNavigator()
  {
  	IWorkbenchPage page = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
  	if(page == null || !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) )
  		return null;
  	
  	IViewPart part = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
  	Navigator navigator = null;
  	if(part!=null && ((PDProjectExplorer)part).isActiveNavigator()){
  		return (INavigator)part;
  	}		
  	
  	part = page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
  	if(part!=null && ((Navigator)part).isActiveNavigator()){
  		return (INavigator)part;
  	}
  	return null;
  	
  }
  
  public static EObject getNavigatorSelection(INavigator navigator){
			
  	  if(navigator==null)
  	  	return null;
	  IStructuredSelection selection = navigator.getStructuredSelection();
	  if(!selection.isEmpty()){
		  Object obj = ((IStructuredSelection)selection).getFirstElement();
				
		  if(obj != null && obj instanceof EObject)
			 return (EObject)obj;					
	  }					

	  return null;
	
  }
  

}
