/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

/**
 * This is the action group for the sort and filter actions.
 */
public class FilterActionGroup extends ActionGroup {

	protected PDViewerFilterAction fShowFolder;
	protected PDViewerFilterAction fShowMonitor;
	protected PDViewerFilterAction fShowProcess;	
	protected PDViewerFilterAction fShowLogAgents;
	protected PDViewerFilterAction fShowNodes;
	protected PDViewerFilterAction fShowProfAgents;
	protected PDProjectViewer viewer;

	public FilterActionGroup(PDProjectViewer viewer) {
		super();
		
		this.viewer = viewer;
		makeActions();
	}

	protected void makeActions() {
		
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();	
		IPluginRegistry reg= Platform.getPluginRegistry();

		// monitor	
		fShowFolder= new PDViewerFilterAction(viewer, UIPlugin.getResourceString("STR_TOOL_BAR_FOLDER"), TraceConstants.FILTER_FOLDER,
							store.getBoolean(TraceConstants.SHOW_FOLDER_KEY));
		fShowFolder.setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_FOLDER));
 
		// monitor	
		fShowMonitor= new PDViewerFilterAction(viewer, UIPlugin.getResourceString("STR_TOOL_BAR_MONITOR"), TraceConstants.FILTER_MONITOR,
							store.getBoolean(TraceConstants.SHOW_MON_KEY));
		fShowMonitor.setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_MONITOR));
		
		// nodes	
		fShowNodes= new PDViewerFilterAction(viewer, UIPlugin.getResourceString("STR_TOOL_BAR_NODES"), TraceConstants.FILTER_NODE
						, store.getBoolean(TraceConstants.SHOW_NODE_KEY));
		fShowNodes.setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_NODE));

		// process	
		fShowProcess= new PDViewerFilterAction(viewer, UIPlugin.getResourceString("STR_TOOL_BAR_PROCESS"), TraceConstants.FILTER_PROCESS
							, store.getBoolean(TraceConstants.SHOW_PROCESS_KEY));
		fShowProcess.setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_PROCESS));

		// log agents	
		fShowLogAgents = new PDViewerFilterAction(viewer, UIPlugin.getResourceString("STR_TOOL_BAR_LOG"), TraceConstants.FILTER_LOG_AGENT
						   , store.getBoolean(TraceConstants.SHOW_LOG_KEY));
		fShowLogAgents.setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_FILTER_LOG_AGENT));

		// prof agents	
		fShowProfAgents = new PDViewerFilterAction(viewer, UIPlugin.getResourceString("STR_TOOL_BAR_PROF"), TraceConstants.FILTER_PROF_AGENT
							, store.getBoolean(TraceConstants.SHOW_PROF_KEY));
		fShowProfAgents.setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_FILTER_PROF_AGENT));
		
	}

	public void fillActionBars(IActionBars actionBars) {
		IMenuManager menu = actionBars.getMenuManager();
		IMenuManager submenu =
			new MenuManager("Filter"); //$NON-NLS-1$
		menu.add(submenu);
		submenu.add(fShowFolder);
		submenu.add(fShowMonitor);
		submenu.add(fShowNodes);
		submenu.add(fShowProcess);
		submenu.add(fShowProfAgents);
		submenu.add(fShowLogAgents);
		
	}

    public void dispose()
    {
     	viewer = null;
		fShowFolder = null;
		fShowLogAgents = null;
		fShowMonitor = null;
		fShowNodes = null;
		fShowProcess = null;
		fShowProfAgents = null;
    	
    }
    
	public void updateActionBars() {
		
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		
		fShowFolder.setChecked(store.getBoolean(TraceConstants.SHOW_FOLDER_KEY), false);
		fShowMonitor.setChecked(store.getBoolean(TraceConstants.SHOW_MON_KEY), false);
		fShowNodes.setChecked(store.getBoolean(TraceConstants.SHOW_NODE_KEY), false);
		fShowProcess.setChecked(store.getBoolean(TraceConstants.SHOW_PROCESS_KEY), false);
		fShowProfAgents.setChecked(store.getBoolean(TraceConstants.SHOW_PROF_KEY), false);
		fShowLogAgents.setChecked(store.getBoolean(TraceConstants.SHOW_LOG_KEY), false);		
	}
}