/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.console;

import java.util.*;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.text.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID cgla0000 for console goto line action
*/

public class ConsoleGotoLineAction extends ConsoleViewerAction {

	/**
	 * Validates whether the text found in the input field of the
	 * dialog forms a valid line number, i.e. one to which can be 
	 * jumped.
	 */
	class NumberValidator implements IInputValidator {

		public String isValid(String input) {
			try {
				int i= Integer.parseInt(input);
				if (i <= 0 || fLastLine < i)
					return fBundle.getString(fPrefix + "dialog.invalid_range");

			} catch (NumberFormatException x) {
				return fBundle.getString(fPrefix + "dialog.invalid_input");
			}

			return null;
		}
	};

	protected int fLastLine;
	protected ResourceBundle fBundle;
	protected String fPrefix;
	protected TraceConsoleViewer fConsoleViewer;
	
	/**
	 * Constructs a goto line action for the console using the provided resource bundle
	 */
	public ConsoleGotoLineAction(ResourceBundle bundle, String prefix, TraceConsoleViewer viewer) {
		super(bundle, prefix, viewer, -1);
		fBundle= bundle;
		fPrefix= prefix;
		fConsoleViewer= viewer;
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this,
		UIPlugin.getPluginId()+".cgla0000");
	}
	/**
	 * Jumps to the line.
	 */
	protected void gotoLine(int line) {

		IDocument document= fConsoleViewer.getDocument();
		try {
			int start= document.getLineOffset(line);
			int length= document.getLineLength(line);

			fConsoleViewer.getTextWidget().setSelection(start);
			fConsoleViewer.revealRange(start, length);
		} catch (BadLocationException x) {
			// ignore
		}
		catch(Exception exc)
		{
		}
	}
	/**
	 * @see Action
	 */
	public void run() {
		try {
			Point selection= fConsoleViewer.getTextWidget().getSelection();
			IDocument document= fConsoleViewer.getDocument();
			fLastLine= document.getLineOfOffset(document.getLength()) + 1;
			int startLine= selection == null ? 1 : fConsoleViewer.getTextWidget().getLineAtOffset(selection.x) + 1;
			String title= fBundle.getString(fPrefix + "dialog.title");
			String message= fBundle.getString(fPrefix + "dialog.message");
			String value= Integer.toString(startLine);
			Shell activeShell= UIPlugin.getActiveWorkbenchWindow().getShell();
			InputDialog d= new InputDialog(activeShell, title, message, value, new NumberValidator());
			d.open();

			try {
				int line= Integer.parseInt(d.getValue());
				gotoLine(line - 1);
			} catch (NumberFormatException x) {
			}
		} catch (BadLocationException x) {
			return;
		}
	}
	/**
	 * @see TextEditorAction
	 */
	public void update() {
	}
}
