/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
* CONTEXT_ID pfwp0000 for profile filters wizard page
*/

public class ProfileOptionsPage extends WizardPage {
	protected TraceProfileUI _profileUI;
	protected String _type;

	public ProfileOptionsPage(String name, String type) {
		super(name);
		_type = type;
		setTitle(UIPlugin.getResourceString("STR_FILTERS_PAGE"));
		setDescription(UIPlugin.getResourceString("STR_FILTERS_DESCR"));
	}

	public void alterFilterSetChildren(FilterSetElement elem, ArrayList children)
	{
		_profileUI.alterFilterSetChildren(elem,children);
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 8:01:42 PM)
	 * @param text java.lang.String
	 */
	public void addFilterSet(String name, boolean enabled, ArrayList children)
   {
   	    FilterSetElement elem = new FilterSetElement(name, enabled);
   	    elem.setChildren(children);
		_profileUI.addFilterSet(elem);
	}
	
	public void createControl(Composite parent) {
		Label label;

		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 0;
		content.setLayout(layout);
		GridData gd = GridUtil.createFill();
		gd.widthHint = 500;
		gd.heightHint = 500;
		content.setLayoutData(gd);

		_profileUI = new TraceProfileUI();
		_profileUI.createControl(content);

		setControl(content);

		initializeValues();

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			this.getControl(),
			UIPlugin.getPluginId() + ".pfwp0000");

	}
	public boolean finish() {
		
		TraceProfileUI.storeValues(_profileUI.getFilterSet());

		return true;

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 10:31:47 AM)
	 * @return java.util.Vector
	 */
	public ArrayList getFilterSet() {
		
		return _profileUI.getFilterSet();
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {

		if (getWizard() instanceof RelaunchWizard) {
			((RelaunchWizard) getWizard()).setAgentFilters();
		} else {
			String filters =
				UIPlugin.getDefault().getPreferenceStore().getString(TraceConstants.FILTERS_SET_KEY);
			
			setFilters(filters);	
		}
	}
	
	public void setFilters(String filters)
	{
		_profileUI.setFilterSet(filters);		
	}
	
	/**
	 * 
	 */
	public void removeFilterSet(int idx)
	{
		_profileUI.removeFilterSet(idx);
	}
	
	/**
	 * Determine whether this page should be enabled.
	 */
	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if (visible) {
			Vector aList = getAgentsList();
			if (aList != null && !hasProfilingAgent(aList)) {
				this.getControl().setEnabled(false);
				this.getControl().setVisible(false);
				this.setDescription(UIPlugin.getResourceString("STR_FILTER_IGNORED"));
			} else {
				this.getControl().setEnabled(true);
				this.getControl().setVisible(true);
				this.setDescription(UIPlugin.getResourceString("STR_FILTERS_DESCR"));
			}
		}
	}
	/**
	 * Get the list of agents depending on the type of wizard.
	 */
	private Vector getAgentsList() {
		DoubleCTree agentList = null;
		Vector aList = null;

		if (_type.equals(TraceConstants.ATTACH_LOCAL_WIZARD)) {
			agentList = ((AttachLocalWizard) getWizard()).getAgentList();
		} else if (_type.equals(TraceConstants.ATTACH_REMOTE_WIZARD)) {
			agentList = ((AttachRemoteWizard) getWizard()).getAgentList();
		}

		if (agentList != null) {
			aList = agentList.getSelectedAgents();
		}

		return aList;
	}
	/**
	 * Return true if have at least one Profiling Agent.
	 */
	private boolean hasProfilingAgent(Vector agents) {
		for (int idx = 0; idx < agents.size(); idx++) {
			Agent agent = (Agent) agents.elementAt(idx);
			if (agent.getType() != null
				&& agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)
				&& !agent.getName().equals(TraceConstants.J2EE_AGENT_NAME)) {
				return true;
			}
		}
		return false;
	}
}
