/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.internal.codegen;

import java.util.Iterator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.util.XMLUtil;


class GenTestSuite
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "\t\t" + NL;
  protected final String TEXT_2 = NL + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL + "<testScript>";
  protected final String TEXT_3 = NL + "<verdicts>";
  protected final String TEXT_4 = NL + "<verdict";
  protected final String TEXT_5 = "/>";
  protected final String TEXT_6 = NL + "</verdicts>" + NL + "</testScript>";

	public String generate(final ITestSuite testSuite, final Helper helper)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
   class Util
   {
      private Set generatedTestSuites;
      private StringBuffer stringBuffer;

   	  public Util(StringBuffer stringBuffer)
   	  {
   	     this.stringBuffer = stringBuffer;
   	  }
   	  
   	  public void dispose()
   	  {
   	     if(generatedTestSuites != null)
   	        generatedTestSuites.clear();
   	  }

	  public void createXMLAttribute(String name, String value)
	  {
	     if((name == null) || (value == null))
	        return;
	     stringBuffer.append(XMLUtil.createXMLAttribute(name, value, false));
      }
      
      public void generate(ITestSuite testSuite)
      {
         if(generatedTestSuites == null)
            generatedTestSuites = new HashSet();
         else if(generatedTestSuites.contains(testSuite))
            return;
         generatedTestSuites.add(testSuite);
      
         stringBuffer.append(NL).append("<testSuite");
         createXMLAttribute("id", testSuite.getId());
         createXMLAttribute("name", testSuite.getName());
         createXMLAttribute("location", helper.getFilePath(testSuite));
         createXMLAttribute("description", testSuite.getDescription());
         
         boolean complex = false;
         
         List list = testSuite.getITestCases();
         if(!list.isEmpty())
         {
            complex = true;
            stringBuffer.append(">");

            stringBuffer.append(NL).append("<testCases>");
            for(Iterator i=list.iterator(); i.hasNext();)
            {
               ITestCase testCase = (ITestCase)i.next();
               stringBuffer.append(NL).append("<testCase");
               createXMLAttribute("id", testCase.getId());
               createXMLAttribute("name", testCase.getName());
               createXMLAttribute("description", testCase.getDescription());
               stringBuffer.append("/>");
            }
            stringBuffer.append(NL).append("</testCases>");
         }

         list = testSuite.getIReferencedSuites();
         if(!list.isEmpty())
         {
            complex = true;
            stringBuffer.append(">");

            stringBuffer.append(NL).append("<referencedTestSuites>");
            complex = true;
            for(Iterator i=list.iterator(); i.hasNext();)
               generate((ITestSuite)i.next());
            stringBuffer.append(NL).append("</referencedTestSuites>");
         }

         if(testSuite.getImplementor() != null)
         {
            list = testSuite.getImplementor().getBlock().getActions();
            if(!list.isEmpty())
            {
               complex = true;
               stringBuffer.append(">");
               
               stringBuffer.append(NL).append("<behavior>");
               complex = true;
               for(Iterator i=list.iterator(); i.hasNext();)
               {
                  IAction action = (IAction)i.next();
                  if(action instanceof ITestInvocation)
                     generate((ITestInvocation)action);
                  else if(action instanceof ILoop)
                     generate((ILoop)action);
               }
               stringBuffer.append(NL).append("</behavior>");
            }
         }
         
         if(complex)
         	stringBuffer.append(NL).append("</testSuite>");
         else
         	stringBuffer.append("/>");
      }
       
      public void generate(ITestInvocation testInvocation)
      {
         stringBuffer.append(NL).append("<testInvocation");
         createXMLAttribute("id", testInvocation.getId());
         createXMLAttribute("name", testInvocation.getName());
         createXMLAttribute("synchronous", new Boolean(testInvocation.isSynchronous()).toString());
         if(testInvocation.getInvokedTest() != null)
            createXMLAttribute("testId", testInvocation.getInvokedTest().getId());
         createXMLAttribute("description", testInvocation.getDescription());
         stringBuffer.append("/>");
      }

      public void generate(ILoop loop)
      {
         stringBuffer.append(NL).append("<loop");
         createXMLAttribute("id", loop.getId());
         createXMLAttribute("name", loop.getName());
         createXMLAttribute("synchronous", new Boolean(loop.isSynchronous()).toString());
         createXMLAttribute("iterations", loop.getCondition().getConstraint());
         createXMLAttribute("description", loop.getDescription());
          
         List actions = loop.getBlock().getActions();
         if(!actions.isEmpty())
         {
            stringBuffer.append(">");
            for(Iterator i=actions.iterator(); i.hasNext();)
            {
               IAction action = (IAction)i.next();
               if(action instanceof ITestInvocation)
                  generate((ITestInvocation)action);
               else if(action instanceof ILoop)
                  generate((ILoop)action);
            }
            stringBuffer.append(NL).append("</loop>");
         }
         else
         { 
            stringBuffer.append("/>");
         }
      }
   }
   Util util = new Util(stringBuffer);

    stringBuffer.append(TEXT_2);
    
   util.generate(testSuite);

    stringBuffer.append(TEXT_3);
    
   for(Iterator i=TPFVerdict.VALUES.iterator(); i.hasNext();)
   {
      TPFVerdict verdict = (TPFVerdict)i.next();
      String labelAtt = XMLUtil.createXMLAttribute("label", verdict.getLabel(), false).toString();
      String valueAtt = XMLUtil.createXMLAttribute("value", Integer.toString(verdict.getValue()), false).toString();
      String isDefaultAtt = XMLUtil.createXMLAttribute("isDefault", new Boolean(verdict.getValue() == TPFVerdict.PASS).toString(), false).toString();

    stringBuffer.append(TEXT_4);
    stringBuffer.append(labelAtt);
    stringBuffer.append(valueAtt);
    stringBuffer.append(isDefaultAtt);
    stringBuffer.append(TEXT_5);
    
	}
	util.dispose();

    stringBuffer.append(TEXT_6);
    
    return stringBuffer.toString();
  }
}
