/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual.internal.editor;

import org.eclipse.jface.action.IAction;

import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.common.internal.editor.action.AddTestCase;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class ManualTestCasesForm
extends TestCasesForm
{
	/**
	 * Constructor for ManualTestCasesForm
	 * @param manualEditorExtension
	 * @param widgetFactory
	 */
	public ManualTestCasesForm(ManualEditorExtension manualEditorExtension, WidgetFactory widgetFactory)
	{
		super(manualEditorExtension, widgetFactory);
		setHeadingText(TestJavaPlugin.getString("W_TST_SUITE"));
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getAddTestCaseAction()
	 */
	protected IAction getAddTestCaseAction()
	{
		return new AddTestCase(this, TestCommon.MANUAL_TEST_CASE_TYPE, TestJavaPlugin.getString("W_TEST").toLowerCase());
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getTestCasesSectionHeaderText()
	 */
	protected String getTestCasesSectionHeaderText()
	{
		return TestJavaPlugin.getString("W_TST_CASES");
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_NAMED_ELEMENT_CONTROL:
				break;
				
			case HELP_TEST_CASES_SECTION_CONTROL:
				break;
				
			case HELP_TEST_CASES_SECTION_TREE_CONTROL:
				break;
		}
	}
}
