/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.probekit.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Fragment Enum</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getFragmentEnum()
 * @model
 * @generated
 */
public final class FragmentEnum extends AbstractEnumerator {
	/**
	 * The '<em><b>Entry</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENTRY_LITERAL
	 * @model name="entry"
	 * @generated
	 * @ordered
	 */
	public static final int ENTRY = 1;

	/**
	 * The '<em><b>Exit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXIT_LITERAL
	 * @model name="exit"
	 * @generated
	 * @ordered
	 */
	public static final int EXIT = 2;

	/**
	 * The '<em><b>Catch</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CATCH_LITERAL
	 * @model name="catch"
	 * @generated
	 * @ordered
	 */
	public static final int CATCH = 3;

	/**
	 * The '<em><b>Before Call</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BEFORE_CALL_LITERAL
	 * @model name="beforeCall"
	 * @generated
	 * @ordered
	 */
	public static final int BEFORE_CALL = 4;

	/**
	 * The '<em><b>After Call</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AFTER_CALL_LITERAL
	 * @model name="afterCall"
	 * @generated
	 * @ordered
	 */
	public static final int AFTER_CALL = 5;

	/**
	 * The '<em><b>Entry</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Entry</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ENTRY
	 * @generated
	 * @ordered
	 */
	public static final FragmentEnum ENTRY_LITERAL = new FragmentEnum(ENTRY, "entry");

	/**
	 * The '<em><b>Exit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Exit</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXIT
	 * @generated
	 * @ordered
	 */
	public static final FragmentEnum EXIT_LITERAL = new FragmentEnum(EXIT, "exit");

	/**
	 * The '<em><b>Catch</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Catch</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CATCH
	 * @generated
	 * @ordered
	 */
	public static final FragmentEnum CATCH_LITERAL = new FragmentEnum(CATCH, "catch");

	/**
	 * The '<em><b>Before Call</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Before Call</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BEFORE_CALL
	 * @generated
	 * @ordered
	 */
	public static final FragmentEnum BEFORE_CALL_LITERAL = new FragmentEnum(BEFORE_CALL, "beforeCall");

	/**
	 * The '<em><b>After Call</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>After Call</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #AFTER_CALL
	 * @generated
	 * @ordered
	 */
	public static final FragmentEnum AFTER_CALL_LITERAL = new FragmentEnum(AFTER_CALL, "afterCall");

	/**
	 * An array of all the '<em><b>Fragment Enum</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final FragmentEnum[] VALUES_ARRAY =
		new FragmentEnum[] {
			ENTRY_LITERAL,
			EXIT_LITERAL,
			CATCH_LITERAL,
			BEFORE_CALL_LITERAL,
			AFTER_CALL_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Fragment Enum</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Fragment Enum</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static FragmentEnum get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			FragmentEnum result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Fragment Enum</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static FragmentEnum get(int value) {
		switch (value) {
			case ENTRY: return ENTRY_LITERAL;
			case EXIT: return EXIT_LITERAL;
			case CATCH: return CATCH_LITERAL;
			case BEFORE_CALL: return BEFORE_CALL_LITERAL;
			case AFTER_CALL: return AFTER_CALL_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private FragmentEnum(int value, String name) {
		super(value, name);
	}

} //FragmentEnum
