/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.probekit.internal;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Probe</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getControlKey <em>Control Key</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getControlName <em>Control Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getTarget <em>Target</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getImport <em>Import</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getFragmentAtClassScope <em>Fragment At Class Scope</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getFragment <em>Fragment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.Probe#getInvocationObject <em>Invocation Object</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe()
 * @model 
 * @generated
 */
public interface Probe extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.probekit.internal.Name}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' containment reference list.
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_Name()
	 * @model type="org.eclipse.hyades.models.probekit.internal.Name" containment="true"
	 * @generated
	 */
	EList getName();

	/**
	 * Returns the value of the '<em><b>Description</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.probekit.internal.Description}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' containment reference list.
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_Description()
	 * @model type="org.eclipse.hyades.models.probekit.internal.Description" containment="true"
	 * @generated
	 */
	EList getDescription();

	/**
	 * Returns the value of the '<em><b>Control Key</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Control Key</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Control Key</em>' containment reference.
	 * @see #setControlKey(ControlKey)
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_ControlKey()
	 * @model containment="true"
	 * @generated
	 */
	ControlKey getControlKey();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.probekit.internal.Probe#getControlKey <em>Control Key</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Control Key</em>' containment reference.
	 * @see #getControlKey()
	 * @generated
	 */
	void setControlKey(ControlKey value);

	/**
	 * Returns the value of the '<em><b>Control Name</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.probekit.internal.ControlName}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Control Name</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Control Name</em>' containment reference list.
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_ControlName()
	 * @model type="org.eclipse.hyades.models.probekit.internal.ControlName" containment="true"
	 * @generated
	 */
	EList getControlName();

	/**
	 * Returns the value of the '<em><b>Target</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.probekit.internal.Target}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target</em>' containment reference list.
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_Target()
	 * @model type="org.eclipse.hyades.models.probekit.internal.Target" containment="true"
	 * @generated
	 */
	EList getTarget();

	/**
	 * Returns the value of the '<em><b>Import</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.probekit.internal.Import}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Import</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Import</em>' containment reference list.
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_Import()
	 * @model type="org.eclipse.hyades.models.probekit.internal.Import" containment="true"
	 * @generated
	 */
	EList getImport();

	/**
	 * Returns the value of the '<em><b>Fragment At Class Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Fragment At Class Scope</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Fragment At Class Scope</em>' containment reference.
	 * @see #setFragmentAtClassScope(FragmentAtClassScope)
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_FragmentAtClassScope()
	 * @model containment="true"
	 * @generated
	 */
	FragmentAtClassScope getFragmentAtClassScope();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.probekit.internal.Probe#getFragmentAtClassScope <em>Fragment At Class Scope</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Fragment At Class Scope</em>' containment reference.
	 * @see #getFragmentAtClassScope()
	 * @generated
	 */
	void setFragmentAtClassScope(FragmentAtClassScope value);

	/**
	 * Returns the value of the '<em><b>Fragment</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.probekit.internal.Fragment}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Fragment</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Fragment</em>' containment reference list.
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_Fragment()
	 * @model type="org.eclipse.hyades.models.probekit.internal.Fragment" containment="true" required="true"
	 * @generated
	 */
	EList getFragment();

	/**
	 * Returns the value of the '<em><b>Invocation Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Invocation Object</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Invocation Object</em>' containment reference.
	 * @see #setInvocationObject(InvocationObject)
	 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getProbe_InvocationObject()
	 * @model containment="true"
	 * @generated
	 */
	InvocationObject getInvocationObject();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.probekit.internal.Probe#getInvocationObject <em>Invocation Object</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Invocation Object</em>' containment reference.
	 * @see #getInvocationObject()
	 * @generated
	 */
	void setInvocationObject(InvocationObject value);

} // Probe
