/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.cbe.*;

import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.cbe.CBEPackage
 * @generated
 */
public class CBEAdapterFactory extends AdapterFactoryImpl {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static CBEPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBEAdapterFactory()
	{
		if (modelPackage == null) {
			modelPackage = CBEPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object)
	{
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CBESwitch modelSwitch =
		new CBESwitch() {
			public Object caseCBECommonBaseEvent(CBECommonBaseEvent object) {
				return createCBECommonBaseEventAdapter();
			}
			public Object caseCBEExtendedDataElement(CBEExtendedDataElement object) {
				return createCBEExtendedDataElementAdapter();
			}
			public Object caseCBEContextDataElement(CBEContextDataElement object) {
				return createCBEContextDataElementAdapter();
			}
			public Object caseCBEComponentIdentification(CBEComponentIdentification object) {
				return createCBEComponentIdentificationAdapter();
			}
			public Object caseCBEMsgDataElement(CBEMsgDataElement object) {
				return createCBEMsgDataElementAdapter();
			}
			public Object caseCBEDefaultEvent(CBEDefaultEvent object) {
				return createCBEDefaultEventAdapter();
			}
			public Object caseCBEDefaultElement(CBEDefaultElement object) {
				return createCBEDefaultElementAdapter();
			}
			public Object caseCBESituation(CBESituation object) {
				return createCBESituationAdapter();
			}
			public Object caseCBEStartSituation(CBEStartSituation object) {
				return createCBEStartSituationAdapter();
			}
			public Object caseCBEConnectSituation(CBEConnectSituation object) {
				return createCBEConnectSituationAdapter();
			}
			public Object caseCBEStopSituation(CBEStopSituation object) {
				return createCBEStopSituationAdapter();
			}
			public Object caseCBEReportSituation(CBEReportSituation object) {
				return createCBEReportSituationAdapter();
			}
			public Object caseCBEFeatureSituation(CBEFeatureSituation object) {
				return createCBEFeatureSituationAdapter();
			}
			public Object caseCBEConfigureSituation(CBEConfigureSituation object) {
				return createCBEConfigureSituationAdapter();
			}
			public Object caseCBEDependencySituation(CBEDependencySituation object) {
				return createCBEDependencySituationAdapter();
			}
			public Object caseCBECreateSituation(CBECreateSituation object) {
				return createCBECreateSituationAdapter();
			}
			public Object caseCBEDestroySituation(CBEDestroySituation object) {
				return createCBEDestroySituationAdapter();
			}
			public Object caseCBEAvailableSituation(CBEAvailableSituation object) {
				return createCBEAvailableSituationAdapter();
			}
			public Object caseCBERequestSituation(CBERequestSituation object) {
				return createCBERequestSituationAdapter();
			}
			public Object caseCBEOtherSituation(CBEOtherSituation object) {
				return createCBEOtherSituationAdapter();
			}
			public Object caseAbstractDefaultEvent(AbstractDefaultEvent object) {
				return createAbstractDefaultEventAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target)
	{
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBECommonBaseEvent <em>Common Base Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBECommonBaseEvent
	 * @generated
	 */
	public Adapter createCBECommonBaseEventAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEExtendedDataElement <em>Extended Data Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEExtendedDataElement
	 * @generated
	 */
	public Adapter createCBEExtendedDataElementAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEContextDataElement <em>Context Data Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEContextDataElement
	 * @generated
	 */
	public Adapter createCBEContextDataElementAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEComponentIdentification <em>Component Identification</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEComponentIdentification
	 * @generated
	 */
	public Adapter createCBEComponentIdentificationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEMsgDataElement <em>Msg Data Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEMsgDataElement
	 * @generated
	 */
	public Adapter createCBEMsgDataElementAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEDefaultEvent <em>Default Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEDefaultEvent
	 * @generated
	 */
	public Adapter createCBEDefaultEventAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEDefaultElement <em>Default Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEDefaultElement
	 * @generated
	 */
	public Adapter createCBEDefaultElementAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBESituation <em>Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBESituation
	 * @generated
	 */
	public Adapter createCBESituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEStartSituation <em>Start Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEStartSituation
	 * @generated
	 */
	public Adapter createCBEStartSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEConnectSituation <em>Connect Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEConnectSituation
	 * @generated
	 */
	public Adapter createCBEConnectSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEStopSituation <em>Stop Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEStopSituation
	 * @generated
	 */
	public Adapter createCBEStopSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEReportSituation <em>Report Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEReportSituation
	 * @generated
	 */
	public Adapter createCBEReportSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEFeatureSituation <em>Feature Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEFeatureSituation
	 * @generated
	 */
	public Adapter createCBEFeatureSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEConfigureSituation <em>Configure Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEConfigureSituation
	 * @generated
	 */
	public Adapter createCBEConfigureSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEDependencySituation <em>Dependency Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEDependencySituation
	 * @generated
	 */
	public Adapter createCBEDependencySituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBECreateSituation <em>Create Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBECreateSituation
	 * @generated
	 */
	public Adapter createCBECreateSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEDestroySituation <em>Destroy Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEDestroySituation
	 * @generated
	 */
	public Adapter createCBEDestroySituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEAvailableSituation <em>Available Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEAvailableSituation
	 * @generated
	 */
	public Adapter createCBEAvailableSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBERequestSituation <em>Request Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBERequestSituation
	 * @generated
	 */
	public Adapter createCBERequestSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.cbe.CBEOtherSituation <em>Other Situation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.cbe.CBEOtherSituation
	 * @generated
	 */
	public Adapter createCBEOtherSituationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent <em>Abstract Default Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent
	 * @generated
	 */
	public Adapter createAbstractDefaultEventAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter()
	{
		return null;
	}

} //CBEAdapterFactory
