/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGConcurrency;
import org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Deployment Spec</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGDeploymentSpecImpl#getDeploymentLocation <em>Deployment Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGDeploymentSpecImpl#getExecutionLocation <em>Execution Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGDeploymentSpecImpl#getConcurrencyMode <em>Concurrency Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGDeploymentSpecImpl#getArtifact <em>Artifact</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGDeploymentSpecImpl#getDeployment <em>Deployment</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGDeploymentSpecImpl extends CMNNamedElementImpl implements CFGDeploymentSpec
{
	/**
	 * The default value of the '{@link #getDeploymentLocation() <em>Deployment Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeploymentLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String DEPLOYMENT_LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDeploymentLocation() <em>Deployment Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeploymentLocation()
	 * @generated
	 * @ordered
	 */
	protected String deploymentLocation = DEPLOYMENT_LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getExecutionLocation() <em>Execution Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExecutionLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String EXECUTION_LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getExecutionLocation() <em>Execution Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExecutionLocation()
	 * @generated
	 * @ordered
	 */
	protected String executionLocation = EXECUTION_LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getConcurrencyMode() <em>Concurrency Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConcurrencyMode()
	 * @generated
	 * @ordered
	 */
	protected static final CFGConcurrency CONCURRENCY_MODE_EDEFAULT = CFGConcurrency.THREAD_LITERAL;

	/**
	 * The cached value of the '{@link #getConcurrencyMode() <em>Concurrency Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConcurrencyMode()
	 * @generated
	 * @ordered
	 */
	protected CFGConcurrency concurrencyMode = CONCURRENCY_MODE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getArtifact() <em>Artifact</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArtifact()
	 * @generated
	 * @ordered
	 */
	protected EList artifact = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGDeploymentSpecImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_ConfigurationPackage.eINSTANCE.getCFGDeploymentSpec();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDeploymentLocation()
	{
		return deploymentLocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeploymentLocation(String newDeploymentLocation)
	{
		String oldDeploymentLocation = deploymentLocation;
		deploymentLocation = newDeploymentLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT_LOCATION, oldDeploymentLocation, deploymentLocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getExecutionLocation()
	{
		return executionLocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExecutionLocation(String newExecutionLocation)
	{
		String oldExecutionLocation = executionLocation;
		executionLocation = newExecutionLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__EXECUTION_LOCATION, oldExecutionLocation, executionLocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGConcurrency getConcurrencyMode()
	{
		return concurrencyMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConcurrencyMode(CFGConcurrency newConcurrencyMode)
	{
		CFGConcurrency oldConcurrencyMode = concurrencyMode;
		concurrencyMode = newConcurrencyMode == null ? CONCURRENCY_MODE_EDEFAULT : newConcurrencyMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__CONCURRENCY_MODE, oldConcurrencyMode, concurrencyMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getArtifact()
	{
		if (artifact == null) {
			artifact = new EObjectWithInverseResolvingEList(CFGArtifact.class, this, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT, Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC);
		}
		return artifact;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFDeployment getDeployment()
	{
		if (eContainerFeatureID != Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT) return null;
		return (TPFDeployment)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeployment(TPFDeployment newDeployment)
	{
		if (newDeployment != eContainer || (eContainerFeatureID != Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT && newDeployment != null)) {
			if (EcoreUtil.isAncestor(this, newDeployment))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDeployment != null)
				msgs = ((InternalEObject)newDeployment).eInverseAdd(this, Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS, TPFDeployment.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newDeployment, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT, newDeployment, newDeployment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT:
					return ((InternalEList)getArtifact()).basicAdd(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT:
					return ((InternalEList)getArtifact()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT:
					return eBasicSetContainer(null, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS, TPFDeployment.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ID:
				return getId();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__NAME:
				return getName();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DESCRIPTION:
				return getDescription();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT_LOCATION:
				return getDeploymentLocation();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__EXECUTION_LOCATION:
				return getExecutionLocation();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__CONCURRENCY_MODE:
				return getConcurrencyMode();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT:
				return getArtifact();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT:
				return getDeployment();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ID:
				setId((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__NAME:
				setName((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT_LOCATION:
				setDeploymentLocation((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__EXECUTION_LOCATION:
				setExecutionLocation((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__CONCURRENCY_MODE:
				setConcurrencyMode((CFGConcurrency)newValue);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT:
				getArtifact().clear();
				getArtifact().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT:
				setDeployment((TPFDeployment)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT_LOCATION:
				setDeploymentLocation(DEPLOYMENT_LOCATION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__EXECUTION_LOCATION:
				setExecutionLocation(EXECUTION_LOCATION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__CONCURRENCY_MODE:
				setConcurrencyMode(CONCURRENCY_MODE_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT:
				getArtifact().clear();
				return;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT:
				setDeployment((TPFDeployment)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT_LOCATION:
				return DEPLOYMENT_LOCATION_EDEFAULT == null ? deploymentLocation != null : !DEPLOYMENT_LOCATION_EDEFAULT.equals(deploymentLocation);
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__EXECUTION_LOCATION:
				return EXECUTION_LOCATION_EDEFAULT == null ? executionLocation != null : !EXECUTION_LOCATION_EDEFAULT.equals(executionLocation);
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__CONCURRENCY_MODE:
				return concurrencyMode != CONCURRENCY_MODE_EDEFAULT;
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT:
				return artifact != null && !artifact.isEmpty();
			case Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT:
				return getDeployment() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (deploymentLocation: ");
		result.append(deploymentLocation);
		result.append(", executionLocation: ");
		result.append(executionLocation);
		result.append(", concurrencyMode: ");
		result.append(concurrencyMode);
		result.append(')');
		return result.toString();
	}

} //CFGDeploymentSpecImpl
