/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;

import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLVariable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Datapool</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl#getEquivalenceClasses <em>Equivalence Classes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl#getVariables <em>Variables</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLDatapoolImpl extends CMNNamedElementImpl implements DPLDatapool {
	/**
	 * The cached value of the '{@link #getEquivalenceClasses() <em>Equivalence Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEquivalenceClasses()
	 * @generated
	 * @ordered
	 */
	protected EList equivalenceClasses = null;

	/**
	 * The cached value of the '{@link #getVariables() <em>Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariables()
	 * @generated
	 * @ordered
	 */
	protected EList variables = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLDatapoolImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_DatapoolPackage.eINSTANCE.getDPLDatapool();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getEquivalenceClasses()
	{
		if (equivalenceClasses == null) {
			equivalenceClasses = new EObjectContainmentWithInverseEList(DPLEquivalenceClass.class, this, Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES, Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL);
		}
		return equivalenceClasses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getVariables()
	{
		if (variables == null) {
			variables = new EObjectContainmentWithInverseEList(DPLVariable.class, this, Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES, Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL);
		}
		return variables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
					return ((InternalEList)getEquivalenceClasses()).basicAdd(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES:
					return ((InternalEList)getVariables()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
					return ((InternalEList)getEquivalenceClasses()).basicRemove(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES:
					return ((InternalEList)getVariables()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				return getId();
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				return getName();
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				return getDescription();
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				return getEquivalenceClasses();
			case Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES:
				return getVariables();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				setId((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				setName((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				getEquivalenceClasses().clear();
				getEquivalenceClasses().addAll((Collection)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES:
				getVariables().clear();
				getVariables().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				getEquivalenceClasses().clear();
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES:
				getVariables().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				return equivalenceClasses != null && !equivalenceClasses.isEmpty();
			case Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES:
				return variables != null && !variables.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //DPLDatapoolImpl
