/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;

import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Equivalence Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl#getDatapool <em>Datapool</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl#getRecord <em>Record</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLEquivalenceClassImpl extends CMNNamedElementImpl implements DPLEquivalenceClass {
	/**
	 * The cached value of the '{@link #getRecord() <em>Record</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecord()
	 * @generated
	 * @ordered
	 */
	protected EList record = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLEquivalenceClassImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_DatapoolPackage.eINSTANCE.getDPLEquivalenceClass();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLDatapool getDatapool()
	{
		if (eContainerFeatureID != Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL) return null;
		return (DPLDatapool)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDatapool(DPLDatapool newDatapool)
	{
		if (newDatapool != eContainer || (eContainerFeatureID != Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL && newDatapool != null)) {
			if (EcoreUtil.isAncestor(this, newDatapool))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDatapool != null)
				msgs = ((InternalEObject)newDatapool).eInverseAdd(this, Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES, DPLDatapool.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newDatapool, Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL, newDatapool, newDatapool));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRecord()
	{
		if (record == null) {
			record = new EObjectContainmentWithInverseEList(DPLRecord.class, this, Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORD, Common_DatapoolPackage.DPL_RECORD__EQUIVALENCE_CLASS);
		}
		return record;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL, msgs);
				case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORD:
					return ((InternalEList)getRecord()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL:
					return eBasicSetContainer(null, Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL, msgs);
				case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORD:
					return ((InternalEList)getRecord()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES, DPLDatapool.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				return getId();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				return getName();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				return getDescription();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL:
				return getDatapool();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORD:
				return getRecord();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				setId((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				setName((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL:
				setDatapool((DPLDatapool)newValue);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORD:
				getRecord().clear();
				getRecord().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL:
				setDatapool((DPLDatapool)null);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORD:
				getRecord().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DATAPOOL:
				return getDatapool() != null;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORD:
				return record != null && !record.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //DPLEquivalenceClassImpl
