/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A condition stores a constraint that can be tested (one that evaluates to a 
 * boolean at runtime).  Conditions are used by decisions and loops to determine 
 * execution paths.  A condition can be visualized as the expression evaluated 
 * by an <code>if</code> statement or a <code>while</code> loop.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface ICondition extends INamedElement{

	/**
	 * Returns the constraint that is the premise for the condition.
	 * 
	 * @return String
	 */
	public String getConstraint();

	/**
	 * Sets the constraint that is the premise for the condition.
	 * 
	 * @param constraint
	 */	
	public void setConstraint(String constraint);
}
