/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.outputter;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.outputter.OutputterConfigType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class OutputterConfigTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_OUT_DESCR");
	public static final String UNIQUE_ID = AcadEditorPlugin.getPlugin().getString("STR_OUT_ID");
	
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterConfigTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDescriptionPropertyDescriptor(object);
			addTypePropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_OUT_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_OUT_DESCR", "_UI_OutputterConfigType_type"),
				 OutputterPackage.eINSTANCE.getOutputterConfigType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_OutputterConfigType_type_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OutputterConfigType_type_feature", "_UI_OutputterConfigType_type"),
				 OutputterPackage.eINSTANCE.getOutputterConfigType_Type(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_OUT_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_OUT_ID", "_UI_OutputterConfigType_type"),
				 OutputterPackage.eINSTANCE.getOutputterConfigType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(OutputterPackage.eINSTANCE.getOutputterConfigType_SingleFileOutputterType());
			childrenReferences.add(OutputterPackage.eINSTANCE.getOutputterConfigType_StandardOutOutputterType());
			childrenReferences.add(OutputterPackage.eINSTANCE.getOutputterConfigType_LoggingAgentOutputterType());
		}
		return childrenReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EReference getChildReference(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildReference(object, child);
	}


	/**
	 * This returns OutputterConfigType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		
		if(object instanceof OutputterConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_OUTPUTTER);
			
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_STREAM);
			
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((OutputterConfigType)object).getUniqueID();
		return label == null || label.length() == 0 ?
			getString("_UI_OutputterConfigType_type") :
			getString("_UI_OutputterConfigType_type") + " [" + label + "]";
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(OutputterConfigType.class)) {
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__DESCRIPTION:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__UNIQUE_ID:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE:
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

        OutputterConfigType outputter = (OutputterConfigType)object;
        if(outputter.getLoggingAgentOutputterType() != null
           || outputter.getSingleFileOutputterType() != null
            || outputter.getStandardOutOutputterType() != null)
            return;
            
		newChildDescriptors.add
			(createChildParameter
				(OutputterPackage.eINSTANCE.getOutputterConfigType_SingleFileOutputterType(),
				 OutputterFactory.eINSTANCE.createSingleFileOutputterType()));

		newChildDescriptors.add
			(createChildParameter
				(OutputterPackage.eINSTANCE.getOutputterConfigType_StandardOutOutputterType(),
				 OutputterFactory.eINSTANCE.createStandardOutOutputterType()));

		newChildDescriptors.add
			(createChildParameter
				(OutputterPackage.eINSTANCE.getOutputterConfigType_LoggingAgentOutputterType(),
				 OutputterFactory.eINSTANCE.createLoggingAgentOutputterType()));
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
