/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.ui.internal.parser;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.parser.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.parser.RuleAttributeType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RuleAttributeTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String NAME = AcadEditorPlugin.getPlugin().getString("STR_ATTR_NAME");		

	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuleAttributeTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addIdPropertyDescriptor(object);
			addIndexPropertyDescriptor(object);
			addNamePropertyDescriptor(object);
			addUsePreviousMatchSubstitutionAsDefaultPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Id feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ATTR_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_ATTR_ID", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_Id(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Index feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIndexPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ATTR_INDEX"),
				 getString("_UI_PropertyDescriptor_description", "STR_ATTR_INDEX", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_Index(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ATTR_NAME"),
				 getString("_UI_PropertyDescriptor_description", "STR_ATTR_NAME", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Use Previous Match Substitution As Default feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUsePreviousMatchSubstitutionAsDefaultPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_USE_PREV_ATTR"),
				 getString("_UI_PropertyDescriptor_description", "STR_USE_PREV_ATTR", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_UsePreviousMatchSubstitutionAsDefault(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ParserPackage.eINSTANCE.getRuleAttributeType_SubstitutionRule());
		}
		return childrenReferences;
	}


	/**
	 * This returns RuleAttributeType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		if(object instanceof SubstitutionRuleType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_RULE);
		
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_ATTRIBUTE);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((RuleAttributeType)object).getName();
		return label == null || label.length() == 0 ?
			"" : label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(RuleAttributeType.class)) {
			case ParserPackage.RULE_ATTRIBUTE_TYPE__ID:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__INDEX:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__NAME:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

        SubstitutionRuleType subs = ParserFactory.eINSTANCE.createSubstitutionRuleType();
        subs.setUseBuiltInFunction(true);
        subs.setUseBuiltInFunction(false);
		newChildDescriptors.add
			(createChildParameter
				(ParserPackage.eINSTANCE.getRuleAttributeType_SubstitutionRule(),
				 subs));
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
